/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.stream.binder.Binding;
import org.springframework.context.Lifecycle;
import org.springframework.integration.endpoint.Pausable;
import org.springframework.integration.support.context.NamedComponent;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@JsonPropertyOrder(value={"name", "group", "pausable", "state"})
@JsonIgnoreProperties(value={"running"})
public class DefaultBinding<T>
implements Binding<T> {
    private final Log logger = LogFactory.getLog((String)this.getClass().getName());
    protected final String name;
    protected final String group;
    protected final T target;
    protected final Lifecycle lifecycle;
    private boolean paused;

    public DefaultBinding(String name, String group, T target, Lifecycle lifecycle) {
        Assert.notNull(target, (String)"target must not be null");
        this.name = name;
        this.group = group;
        this.target = target;
        this.lifecycle = lifecycle;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getGroup() {
        return this.group;
    }

    public String getState() {
        String state = "N/A";
        if (this.lifecycle != null) {
            state = this.isPausable() ? (this.paused ? "paused" : this.getRunningState()) : this.getRunningState();
        }
        return state;
    }

    @Override
    public boolean isRunning() {
        return this.lifecycle != null && this.lifecycle.isRunning();
    }

    public boolean isPausable() {
        return this.lifecycle instanceof Pausable;
    }

    @Override
    public final synchronized void start() {
        if (!this.isRunning()) {
            if (this.lifecycle != null && StringUtils.hasText((String)this.group)) {
                this.lifecycle.start();
            } else {
                this.logger.warn((Object)"Can not re-bind an anonymous binding");
            }
        }
    }

    @Override
    public final synchronized void stop() {
        if (this.isRunning()) {
            this.lifecycle.stop();
        }
    }

    @Override
    public final synchronized void pause() {
        if (this.lifecycle instanceof Pausable) {
            ((Pausable)this.lifecycle).pause();
            this.paused = true;
        } else {
            this.logger.warn((Object)("Attempted to pause a component that does not support Pausable " + this.lifecycle));
        }
    }

    @Override
    public final synchronized void resume() {
        if (this.lifecycle instanceof Pausable) {
            ((Pausable)this.lifecycle).resume();
            this.paused = false;
        } else {
            this.logger.warn((Object)("Attempted to resume a component that does not support Pausable " + this.lifecycle));
        }
    }

    @Override
    public final void unbind() {
        this.stop();
        this.afterUnbind();
    }

    Lifecycle getEndpoint() {
        return this.lifecycle;
    }

    public String toString() {
        return " Binding [name=" + this.name + ", target=" + this.target + ", lifecycle=" + (this.lifecycle instanceof NamedComponent ? ((NamedComponent)this.lifecycle).getComponentName() : ObjectUtils.nullSafeToString((Object)this.lifecycle)) + "]";
    }

    protected void afterUnbind() {
    }

    private String getRunningState() {
        return this.isRunning() ? "running" : "stopped";
    }
}

