/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.zipkin2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.cloud.sleuth.zipkin2.ZipkinAutoConfiguration;
import org.springframework.cloud.sleuth.zipkin2.ZipkinProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.Assert;
import zipkin2.Span;
import zipkin2.codec.BytesEncoder;
import zipkin2.reporter.AsyncReporter;
import zipkin2.reporter.InMemoryReporterMetrics;
import zipkin2.reporter.Reporter;
import zipkin2.reporter.ReporterMetrics;
import zipkin2.reporter.Sender;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(value={"spring.sleuth.enabled", "spring.zipkin.enabled"}, matchIfMissing=true)
@AutoConfigureBefore(value={ZipkinAutoConfiguration.class})
@Deprecated
public class ZipkinBackwardsCompatibilityAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @Deprecated
    BytesEncoder<Span> spanBytesEncoder(ZipkinProperties zipkinProperties) {
        return zipkinProperties.getEncoder();
    }

    static class BackwardsCompatibilityCondition
    extends SpringBootCondition
    implements ConfigurationCondition {
        BackwardsCompatibilityCondition() {
        }

        public ConfigurationCondition.ConfigurationPhase getConfigurationPhase() {
            return ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN;
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            Assert.isInstanceOf(DefaultListableBeanFactory.class, (Object)context.getBeanFactory());
            DefaultListableBeanFactory listableBeanFactory = (DefaultListableBeanFactory)context.getBeanFactory();
            String[] foundSenders = listableBeanFactory.getBeanNamesForType(Sender.class);
            int foundSendersSize = foundSenders.length;
            if (foundSendersSize != 1) {
                return ConditionOutcome.noMatch((String)"None or multiple Sender beans found - no reason to apply backwards compatibility");
            }
            if (foundSenders[0].equals("zipkinSender")) {
                return ConditionOutcome.noMatch((String)"A single, [zipkinSender] named bean found - no reason to apply backwards compatibility");
            }
            int foundReporters = listableBeanFactory.getBeanNamesForType(Reporter.class).length;
            if (foundReporters > 0) {
                return ConditionOutcome.noMatch((String)"The old config setup already defines its own Reporter bean");
            }
            return ConditionOutcome.match();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Conditional(value={BackwardsCompatibilityCondition.class})
    static class BackwardsCompatibilityConfiguration {
        BackwardsCompatibilityConfiguration() {
        }

        @Bean
        @Deprecated
        Reporter<Span> reporter(ReporterMetrics reporterMetrics, ZipkinProperties zipkin, BytesEncoder<Span> spanBytesEncoder, DefaultListableBeanFactory beanFactory) {
            ArrayList<String> beanNames = new ArrayList<String>(Arrays.asList(beanFactory.getBeanNamesForType(Sender.class)));
            beanNames.remove("zipkinSender");
            Sender sender = (Sender)beanFactory.getBean((String)beanNames.get(0));
            return AsyncReporter.builder((Sender)sender).queuedMaxSpans(1000).messageTimeout((long)zipkin.getMessageTimeout(), TimeUnit.SECONDS).metrics(reporterMetrics).build(spanBytesEncoder);
        }

        @Bean
        @ConditionalOnMissingBean
        @Deprecated
        ReporterMetrics zipkinReporterMetrics() {
            return new InMemoryReporterMetrics();
        }
    }
}

