/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.brave.instrument.web;

import brave.http.HttpRequest;
import brave.sampler.SamplerFunction;
import java.util.regex.Pattern;

abstract class SkipPatternSampler
implements SamplerFunction<HttpRequest> {
    private Pattern pattern;

    SkipPatternSampler() {
    }

    public final Boolean trySample(HttpRequest request) {
        String url = request.path();
        boolean shouldSkip = this.pattern().matcher(url).matches();
        if (shouldSkip) {
            return false;
        }
        return null;
    }

    abstract Pattern getPattern();

    private Pattern pattern() {
        if (this.pattern == null) {
            this.pattern = this.getPattern();
        }
        return this.pattern;
    }
}

