/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.brave.bridge;

import brave.internal.propagation.StringPropagationAdapter;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.brave.bridge.BigendianEncoding;
import org.springframework.cloud.sleuth.brave.bridge.BraveBaggageManager;
import org.springframework.cloud.sleuth.brave.bridge.TemporaryBuffers;
import org.springframework.cloud.sleuth.brave.bridge.TraceFlags;
import org.springframework.cloud.sleuth.brave.bridge.W3CBaggagePropagator;

class W3CPropagation
extends Propagation.Factory
implements Propagation<String> {
    private static final Log logger = LogFactory.getLog((String)W3CPropagation.class.getName());
    static final String TRACE_PARENT = "traceparent";
    static final String TRACE_STATE = "tracestate";
    private static final List<String> FIELDS = Collections.unmodifiableList(Arrays.asList("traceparent", "tracestate"));
    private static final String VERSION = "00";
    private static final int VERSION_SIZE = 2;
    private static final char TRACEPARENT_DELIMITER = '-';
    private static final int TRACEPARENT_DELIMITER_SIZE = 1;
    private static final int LONG_BYTES = 8;
    private static final int BYTE_BASE16 = 2;
    private static final int LONG_BASE16 = 16;
    private static final int TRACE_ID_HEX_SIZE = 32;
    private static final int SPAN_ID_SIZE = 8;
    private static final int SPAN_ID_HEX_SIZE = 16;
    private static final int FLAGS_SIZE = 1;
    private static final int TRACE_OPTION_HEX_SIZE = 2;
    private static final int TRACE_ID_OFFSET = 3;
    private static final int SPAN_ID_OFFSET = 36;
    private static final int TRACE_OPTION_OFFSET = 53;
    private static final int TRACEPARENT_HEADER_SIZE = 55;
    private static final String INVALID_TRACE_ID = "00000000000000000000000000000000";
    private static final String INVALID_SPAN_ID = "0000000000000000";
    private static final Set<String> VALID_VERSIONS = new HashSet<String>();
    private static final String VERSION_00 = "00";
    private final W3CBaggagePropagator baggagePropagator;

    W3CPropagation(BraveBaggageManager braveBaggageManager, List<String> localFields) {
        this.baggagePropagator = new W3CBaggagePropagator(braveBaggageManager, localFields);
    }

    public <K> Propagation<K> create(Propagation.KeyFactory<K> keyFactory) {
        return StringPropagationAdapter.create((Propagation)this, keyFactory);
    }

    public List<String> keys() {
        return FIELDS;
    }

    public <R> TraceContext.Injector<R> injector(Propagation.Setter<R, String> setter) {
        return (context, carrier) -> {
            Objects.requireNonNull(context, "context");
            Objects.requireNonNull(setter, "setter");
            char[] chars = TemporaryBuffers.chars(55);
            chars[0] = "00".charAt(0);
            chars[1] = "00".charAt(1);
            chars[2] = 45;
            String traceId = this.padLeftWithZeros(context.traceIdString(), 32);
            for (int i = 0; i < traceId.length(); ++i) {
                chars[3 + i] = traceId.charAt(i);
            }
            chars[35] = 45;
            String spanId = context.spanIdString();
            for (int i = 0; i < spanId.length(); ++i) {
                chars[36 + i] = spanId.charAt(i);
            }
            chars[52] = 45;
            this.copyTraceFlagsHexTo(chars, 53, context);
            setter.put(carrier, (Object)TRACE_PARENT, new String(chars, 0, 55));
            this.baggagePropagator.injector(setter).inject(context, carrier);
        };
    }

    private String padLeftWithZeros(String string, int length) {
        if (string.length() >= length) {
            return string;
        }
        StringBuilder sb = new StringBuilder(length);
        for (int i = string.length(); i < length; ++i) {
            sb.append('0');
        }
        return sb.append(string).toString();
    }

    void copyTraceFlagsHexTo(char[] dest, int destOffset, TraceContext context) {
        dest[destOffset] = 48;
        dest[destOffset + 1] = Boolean.TRUE.equals(context.sampled()) ? 49 : 48;
    }

    public <R> TraceContext.Extractor<R> extractor(Propagation.Getter<R, String> getter) {
        Objects.requireNonNull(getter, "getter");
        return carrier -> {
            String traceParent = getter.get(carrier, (Object)TRACE_PARENT);
            if (traceParent == null) {
                return this.withBaggage(TraceContextOrSamplingFlags.EMPTY, carrier, getter);
            }
            TraceContext contextFromParentHeader = W3CPropagation.extractContextFromTraceParent(traceParent);
            if (contextFromParentHeader == null) {
                return this.withBaggage(TraceContextOrSamplingFlags.EMPTY, carrier, getter);
            }
            String traceStateHeader = getter.get(carrier, (Object)TRACE_STATE);
            return this.withBaggage(this.context(contextFromParentHeader, traceStateHeader), carrier, getter);
        };
    }

    private <R> TraceContextOrSamplingFlags withBaggage(TraceContextOrSamplingFlags context, R carrier, Propagation.Getter<R, String> getter) {
        if (context.context() == null) {
            return context;
        }
        return this.baggagePropagator.contextWithBaggage(carrier, context, getter);
    }

    TraceContextOrSamplingFlags context(TraceContext contextFromParentHeader, String traceStateHeader) {
        if (traceStateHeader == null || traceStateHeader.isEmpty()) {
            return TraceContextOrSamplingFlags.create((TraceContext)contextFromParentHeader);
        }
        try {
            return TraceContextOrSamplingFlags.create((TraceContext)TraceContext.newBuilder().traceId(contextFromParentHeader.traceId()).traceIdHigh(contextFromParentHeader.traceIdHigh()).spanId(contextFromParentHeader.spanId()).sampled(contextFromParentHeader.sampled()).shared(true).build());
        }
        catch (IllegalArgumentException e) {
            logger.info((Object)"Unparseable tracestate header. Returning span context without state.");
            return TraceContextOrSamplingFlags.create((TraceContext)contextFromParentHeader);
        }
    }

    private static boolean isTraceIdValid(CharSequence traceId) {
        return traceId.length() == 32 && !INVALID_TRACE_ID.contentEquals(traceId) && BigendianEncoding.isValidBase16String(traceId);
    }

    private static boolean isSpanIdValid(String spanId) {
        return spanId.length() == 16 && !INVALID_SPAN_ID.equals(spanId) && BigendianEncoding.isValidBase16String(spanId);
    }

    private static TraceContext extractContextFromTraceParent(String traceparent) {
        boolean isValid;
        boolean bl = isValid = (traceparent.length() == 55 || traceparent.length() > 55 && traceparent.charAt(55) == '-') && traceparent.charAt(2) == '-' && traceparent.charAt(35) == '-' && traceparent.charAt(52) == '-';
        if (!isValid) {
            logger.info((Object)"Unparseable traceparent header. Returning INVALID span context.");
            return null;
        }
        try {
            String version = traceparent.substring(0, 2);
            if (!VALID_VERSIONS.contains(version)) {
                return null;
            }
            if (version.equals("00") && traceparent.length() > 55) {
                return null;
            }
            String traceId = traceparent.substring(3, 35);
            String spanId = traceparent.substring(36, 52);
            if (W3CPropagation.isTraceIdValid(traceId) && W3CPropagation.isSpanIdValid(spanId)) {
                String traceIdHigh = traceId.substring(0, traceId.length() / 2);
                String traceIdLow = traceId.substring(traceId.length() / 2);
                byte isSampled = TraceFlags.byteFromHex(traceparent, 53);
                return TraceContext.newBuilder().shared(true).traceIdHigh(BigendianEncoding.longFromBase16String(traceIdHigh)).traceId(BigendianEncoding.longFromBase16String(traceIdLow)).spanId(BigendianEncoding.longFromBase16String(spanId)).sampled(isSampled == 1).build();
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            logger.info((Object)"Unparseable traceparent header. Returning INVALID span context.");
            return null;
        }
    }

    static {
        for (int i = 0; i < 255; ++i) {
            String version = Long.toHexString(i);
            if (version.length() < 2) {
                version = '0' + version;
            }
            VALID_VERSIONS.add(version);
        }
    }
}

