/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.zipkin2;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.cloud.sleuth.autoconfig.zipkin2.ZipkinActiveMqSenderConfiguration;
import org.springframework.cloud.sleuth.autoconfig.zipkin2.ZipkinKafkaSenderConfiguration;
import org.springframework.cloud.sleuth.autoconfig.zipkin2.ZipkinRabbitSenderConfiguration;
import org.springframework.cloud.sleuth.autoconfig.zipkin2.ZipkinRestTemplateSenderConfiguration;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.type.AnnotationMetadata;

class ZipkinSenderConfigurationImportSelector
implements ImportSelector {
    static final Map<String, String> MAPPINGS;

    ZipkinSenderConfigurationImportSelector() {
    }

    static String getType(String configurationClassName) {
        for (Map.Entry<String, String> entry : MAPPINGS.entrySet()) {
            if (!entry.getValue().equals(configurationClassName)) continue;
            return entry.getKey();
        }
        throw new IllegalStateException("Unknown configuration class " + configurationClassName);
    }

    public String[] selectImports(AnnotationMetadata importingClassMetadata) {
        return MAPPINGS.values().toArray(new String[0]);
    }

    static {
        LinkedHashMap<String, String> mappings = new LinkedHashMap<String, String>();
        mappings.put("activemq", ZipkinActiveMqSenderConfiguration.class.getName());
        mappings.put("rabbit", ZipkinRabbitSenderConfiguration.class.getName());
        mappings.put("kafka", ZipkinKafkaSenderConfiguration.class.getName());
        mappings.put("web", ZipkinRestTemplateSenderConfiguration.class.getName());
        MAPPINGS = Collections.unmodifiableMap(mappings);
    }
}

