/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.brave.instrument.web.client;

import brave.http.HttpTracing;
import brave.httpasyncclient.TracingHttpAsyncClientBuilder;
import brave.httpclient.TracingHttpClientBuilder;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.commons.httpclient.HttpClientConfiguration;
import org.springframework.cloud.sleuth.autoconfig.instrument.web.client.ConditionalnOnSleuthWebClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalnOnSleuthWebClient
@ConditionalOnBean(value={HttpTracing.class})
@AutoConfigureBefore(value={HttpClientConfiguration.class})
public class BraveWebClientAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={HttpAsyncClientBuilder.class})
    static class HttpAsyncClientBuilderConfig {
        HttpAsyncClientBuilderConfig() {
        }

        @Bean
        @ConditionalOnMissingBean
        HttpAsyncClientBuilder traceHttpAsyncClientBuilder(HttpTracing httpTracing) {
            return TracingHttpAsyncClientBuilder.create((HttpTracing)httpTracing);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={HttpClientBuilder.class})
    static class HttpClientBuilderConfig {
        HttpClientBuilderConfig() {
        }

        @Bean
        @ConditionalOnMissingBean
        HttpClientBuilder traceHttpClientBuilder(HttpTracing httpTracing) {
            return TracingHttpClientBuilder.create((HttpTracing)httpTracing);
        }
    }
}

