/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.security.oauth2.client;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.security.oauth2.OAuth2AutoConfiguration;
import org.springframework.cloud.security.oauth2.client.AccessTokenContextRelay;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.config.annotation.web.configuration.OAuth2ClientConfiguration;
import org.springframework.security.oauth2.config.annotation.web.configuration.ResourceServerConfiguration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Configuration
@AutoConfigureAfter(value={OAuth2AutoConfiguration.class})
@ConditionalOnOAuth2ClientInResourceServer
@ConditionalOnClass(value={ResourceServerConfiguration.class})
@ConditionalOnWebApplication
public class ResourceServerTokenRelayAutoConfiguration {
    @Bean
    public AccessTokenContextRelay accessTokenContextRelay(OAuth2ClientContext context) {
        return new AccessTokenContextRelay(context);
    }

    private static class OAuth2OnClientInResourceServerCondition
    extends AllNestedConditions {
        public OAuth2OnClientInResourceServerCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnBean(value={OAuth2ClientConfiguration.class})
        static class Client {
            Client() {
            }
        }

        @ConditionalOnBean(value={ResourceServerConfiguration.class})
        static class Server {
            Server() {
            }
        }
    }

    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    @Conditional(value={OAuth2OnClientInResourceServerCondition.class})
    static @interface ConditionalOnOAuth2ClientInResourceServer {
    }

    @Configuration
    public static class ResourceServerTokenRelayRegistrationAutoConfiguration
    extends WebMvcConfigurerAdapter {
        @Autowired
        AccessTokenContextRelay accessTokenContextRelay;

        public void addInterceptors(InterceptorRegistry registry) {
            registry.addInterceptor((HandlerInterceptor)new HandlerInterceptorAdapter(){

                public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
                    accessTokenContextRelay.copyToken();
                    return true;
                }
            });
        }
    }
}

