/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.ribbon.apache;

import com.netflix.client.RequestSpecificRetryHandler;
import com.netflix.client.RetryHandler;
import com.netflix.client.config.IClientConfig;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.InterceptorRetryPolicy;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRecoveryCallback;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryContext;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryPolicy;
import org.springframework.cloud.client.loadbalancer.ServiceInstanceChooser;
import org.springframework.cloud.netflix.ribbon.RibbonLoadBalancerClient;
import org.springframework.cloud.netflix.ribbon.RibbonLoadBalancerContext;
import org.springframework.cloud.netflix.ribbon.RibbonProperties;
import org.springframework.cloud.netflix.ribbon.RibbonStatsRecorder;
import org.springframework.cloud.netflix.ribbon.ServerIntrospector;
import org.springframework.cloud.netflix.ribbon.apache.HttpClientStatusCodeException;
import org.springframework.cloud.netflix.ribbon.apache.HttpClientUtils;
import org.springframework.cloud.netflix.ribbon.apache.RibbonApacheHttpRequest;
import org.springframework.cloud.netflix.ribbon.apache.RibbonApacheHttpResponse;
import org.springframework.cloud.netflix.ribbon.apache.RibbonLoadBalancingHttpClient;
import org.springframework.cloud.netflix.ribbon.support.ContextAwareRequest;
import org.springframework.http.HttpRequest;
import org.springframework.retry.RecoveryCallback;
import org.springframework.retry.RetryCallback;
import org.springframework.retry.RetryListener;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.NoBackOffPolicy;
import org.springframework.retry.policy.NeverRetryPolicy;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class RetryableRibbonLoadBalancingHttpClient
extends RibbonLoadBalancingHttpClient {
    private static final Log LOGGER = LogFactory.getLog(RetryableRibbonLoadBalancingHttpClient.class);
    private LoadBalancedRetryFactory loadBalancedRetryFactory;
    private RibbonLoadBalancerContext ribbonLoadBalancerContext;

    public RetryableRibbonLoadBalancingHttpClient(CloseableHttpClient delegate, IClientConfig config, ServerIntrospector serverIntrospector, LoadBalancedRetryFactory loadBalancedRetryFactory) {
        super(delegate, config, serverIntrospector);
        this.loadBalancedRetryFactory = loadBalancedRetryFactory;
    }

    @Override
    public RibbonApacheHttpResponse execute(RibbonApacheHttpRequest request, IClientConfig configOverride) throws Exception {
        RequestConfig.Builder builder = RequestConfig.custom();
        IClientConfig config = configOverride != null ? configOverride : this.config;
        RibbonProperties ribbon = RibbonProperties.from(config);
        builder.setConnectTimeout(ribbon.connectTimeout(this.connectTimeout));
        builder.setSocketTimeout(ribbon.readTimeout(this.readTimeout));
        builder.setRedirectsEnabled(ribbon.isFollowRedirects(this.followRedirects));
        RequestConfig requestConfig = builder.build();
        LoadBalancedRetryPolicy retryPolicy = this.loadBalancedRetryFactory.createRetryPolicy(this.getClientName(), (ServiceInstanceChooser)this);
        RetryCallback retryCallback = context -> {
            HttpUriRequest httpUriRequest;
            CloseableHttpResponse httpResponse;
            RibbonApacheHttpRequest newRequest = request;
            RibbonStatsRecorder statsRecorder = null;
            if (context instanceof LoadBalancedRetryContext) {
                ServiceInstance service = ((LoadBalancedRetryContext)context).getServiceInstance();
                this.validateServiceInstance(service);
                if (service != null) {
                    newRequest = newRequest.withNewUri(UriComponentsBuilder.newInstance().host(service.getHost()).scheme(service.getUri().getScheme()).userInfo(newRequest.getURI().getUserInfo()).port(service.getPort()).path(newRequest.getURI().getRawPath()).query(newRequest.getURI().getQuery()).fragment(newRequest.getURI().getFragment()).build(true).encode().toUri());
                    if (this.ribbonLoadBalancerContext == null) {
                        LOGGER.error((Object)"RibbonLoadBalancerContext is null. Unable to update load balancer stats");
                    } else if (service instanceof RibbonLoadBalancerClient.RibbonServer) {
                        statsRecorder = new RibbonStatsRecorder(this.ribbonLoadBalancerContext, ((RibbonLoadBalancerClient.RibbonServer)service).getServer());
                    }
                }
            }
            if (retryPolicy.retryableStatusCode((httpResponse = ((CloseableHttpClient)this.delegate).execute(httpUriRequest = (newRequest = this.getSecureRequest(newRequest, configOverride)).toRequest(requestConfig))).getStatusLine().getStatusCode())) {
                throw new HttpClientStatusCodeException(this.clientName, (HttpResponse)httpResponse, HttpClientUtils.createEntity((HttpResponse)httpResponse), httpUriRequest.getURI());
            }
            if (statsRecorder != null) {
                statsRecorder.recordStats(httpResponse);
            }
            return new RibbonApacheHttpResponse((HttpResponse)httpResponse, httpUriRequest.getURI());
        };
        LoadBalancedRecoveryCallback<RibbonApacheHttpResponse, HttpResponse> recoveryCallback = new LoadBalancedRecoveryCallback<RibbonApacheHttpResponse, HttpResponse>(){

            protected RibbonApacheHttpResponse createResponse(HttpResponse response, URI uri) {
                return new RibbonApacheHttpResponse(response, uri);
            }
        };
        return this.executeWithRetry(request, retryPolicy, (RetryCallback<RibbonApacheHttpResponse, Exception>)retryCallback, (RecoveryCallback<RibbonApacheHttpResponse>)recoveryCallback);
    }

    @Override
    public boolean isClientRetryable(ContextAwareRequest request) {
        return request != null && this.isRequestRetryable(request);
    }

    private boolean isRequestRetryable(ContextAwareRequest request) {
        if (request.getContext() == null || request.getContext().getRetryable() == null) {
            return true;
        }
        return request.getContext().getRetryable();
    }

    private RibbonApacheHttpResponse executeWithRetry(RibbonApacheHttpRequest request, LoadBalancedRetryPolicy retryPolicy, RetryCallback<RibbonApacheHttpResponse, Exception> callback, RecoveryCallback<RibbonApacheHttpResponse> recoveryCallback) throws Exception {
        RetryTemplate retryTemplate = new RetryTemplate();
        boolean retryable = this.isRequestRetryable(request);
        retryTemplate.setRetryPolicy((org.springframework.retry.RetryPolicy)(retryPolicy == null || !retryable ? new NeverRetryPolicy() : new RetryPolicy(request, retryPolicy, this, this.getClientName())));
        BackOffPolicy backOffPolicy = this.loadBalancedRetryFactory.createBackOffPolicy(this.getClientName());
        retryTemplate.setBackOffPolicy((BackOffPolicy)(backOffPolicy == null ? new NoBackOffPolicy() : backOffPolicy));
        RetryListener[] retryListeners = this.loadBalancedRetryFactory.createRetryListeners(this.getClientName());
        if (retryListeners != null && retryListeners.length != 0) {
            retryTemplate.setListeners(retryListeners);
        }
        return (RibbonApacheHttpResponse)retryTemplate.execute(callback, recoveryCallback);
    }

    @Override
    public RequestSpecificRetryHandler getRequestSpecificRetryHandler(RibbonApacheHttpRequest request, IClientConfig requestConfig) {
        return new RequestSpecificRetryHandler(false, false, RetryHandler.DEFAULT, null);
    }

    public void setRibbonLoadBalancerContext(RibbonLoadBalancerContext ribbonLoadBalancerContext) {
        this.ribbonLoadBalancerContext = ribbonLoadBalancerContext;
    }

    static class RetryPolicy
    extends InterceptorRetryPolicy {
        public RetryPolicy(HttpRequest request, LoadBalancedRetryPolicy policy, ServiceInstanceChooser serviceInstanceChooser, String serviceName) {
            super(request, policy, serviceInstanceChooser, serviceName);
        }
    }
}

