/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.hystrix;

import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixObservableCommand;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import rx.Observable;
import rx.RxReactiveStreams;

public class HystrixCommands {
    public static <T> PublisherBuilder<T> from(Publisher<T> publisher) {
        return new PublisherBuilder<T>(publisher);
    }

    private static class PublisherHystrixCommand<T>
    extends HystrixObservableCommand<T> {
        private Publisher<T> publisher;
        private Function<Throwable, Publisher<T>> fallback;

        protected PublisherHystrixCommand(HystrixObservableCommand.Setter setter, Publisher<T> publisher, Function<Throwable, Publisher<T>> fallback) {
            super(setter);
            this.publisher = publisher;
            this.fallback = fallback;
        }

        protected Observable<T> construct() {
            return RxReactiveStreams.toObservable(this.publisher);
        }

        protected Observable<T> resumeWithFallback() {
            if (this.fallback != null) {
                Publisher<T> fallbackPublisher = this.fallback.apply(this.getExecutionException());
                return RxReactiveStreams.toObservable(fallbackPublisher);
            }
            return super.resumeWithFallback();
        }
    }

    public static class PublisherBuilder<T> {
        private final Publisher<T> publisher;
        private String commandName;
        private String groupName;
        private Function<Throwable, Publisher<T>> fallback;
        private HystrixObservableCommand.Setter setter;
        private HystrixCommandProperties.Setter commandProperties;
        private boolean eager = false;
        private Function<HystrixObservableCommand<T>, Observable<T>> toObservable;

        public PublisherBuilder(Publisher<T> publisher) {
            this.publisher = publisher;
        }

        public PublisherBuilder<T> commandName(String commandName) {
            this.commandName = commandName;
            return this;
        }

        public PublisherBuilder<T> groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public PublisherBuilder<T> fallback(Publisher<T> fallback) {
            this.fallback = throwable -> fallback;
            return this;
        }

        public PublisherBuilder<T> fallback(Function<Throwable, Publisher<T>> fallback) {
            this.fallback = fallback;
            return this;
        }

        public PublisherBuilder<T> setter(HystrixObservableCommand.Setter setter) {
            this.setter = setter;
            return this;
        }

        public PublisherBuilder<T> commandProperties(HystrixCommandProperties.Setter commandProperties) {
            this.commandProperties = commandProperties;
            return this;
        }

        public PublisherBuilder<T> commandProperties(Function<HystrixCommandProperties.Setter, HystrixCommandProperties.Setter> commandProperties) {
            if (commandProperties == null) {
                throw new IllegalArgumentException("commandProperties must not both be null");
            }
            return this.commandProperties(commandProperties.apply(HystrixCommandProperties.Setter()));
        }

        public PublisherBuilder<T> eager() {
            this.eager = true;
            return this;
        }

        public PublisherBuilder<T> toObservable(Function<HystrixObservableCommand<T>, Observable<T>> toObservable) {
            this.toObservable = toObservable;
            return this;
        }

        public Publisher<T> build() {
            if (!StringUtils.hasText((String)this.commandName) && this.setter == null) {
                throw new IllegalStateException("commandName and setter can not both be empty");
            }
            HystrixObservableCommand.Setter setterToUse = this.getSetter();
            PublisherHystrixCommand<T> command = new PublisherHystrixCommand<T>(setterToUse, this.publisher, this.fallback);
            Observable<T> observable = this.getObservableFunction().apply(command);
            return RxReactiveStreams.toPublisher(observable);
        }

        public Function<HystrixObservableCommand<T>, Observable<T>> getObservableFunction() {
            Function<Object, Object> observableFunc = this.toObservable != null ? this.toObservable : (this.eager ? cmd -> cmd.observe() : cmd -> cmd.toObservable().onBackpressureBuffer());
            return observableFunc;
        }

        public HystrixObservableCommand.Setter getSetter() {
            HystrixObservableCommand.Setter setterToUse;
            if (this.setter != null) {
                setterToUse = this.setter;
            } else {
                String groupNameToUse = StringUtils.hasText((String)this.groupName) ? this.groupName : this.commandName + "group";
                HystrixCommandGroupKey groupKey = HystrixCommandGroupKey.Factory.asKey((String)groupNameToUse);
                HystrixCommandKey commandKey = HystrixCommandKey.Factory.asKey((String)this.commandName);
                HystrixCommandProperties.Setter commandProperties = this.commandProperties != null ? this.commandProperties : HystrixCommandProperties.Setter();
                setterToUse = HystrixObservableCommand.Setter.withGroupKey((HystrixCommandGroupKey)groupKey).andCommandKey(commandKey).andCommandPropertiesDefaults(commandProperties);
            }
            return setterToUse;
        }

        public Flux<T> toFlux() {
            return Flux.from(this.build());
        }

        public Mono<T> toMono() {
            return Mono.from(this.build());
        }
    }
}

