/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka;

import com.netflix.appinfo.HealthCheckHandler;
import com.netflix.appinfo.InstanceInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.actuate.health.CompositeHealthIndicator;
import org.springframework.boot.actuate.health.DefaultHealthIndicatorRegistry;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.HealthIndicatorRegistry;
import org.springframework.boot.actuate.health.HealthIndicatorRegistryFactory;
import org.springframework.boot.actuate.health.Status;
import org.springframework.boot.actuate.health.StatusAggregator;
import org.springframework.cloud.client.discovery.health.DiscoveryCompositeHealthContributor;
import org.springframework.cloud.client.discovery.health.DiscoveryCompositeHealthIndicator;
import org.springframework.cloud.netflix.eureka.EurekaHealthIndicator;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;

public class EurekaHealthCheckHandler
implements HealthCheckHandler,
ApplicationContextAware,
InitializingBean {
    private static final Map<Status, InstanceInfo.InstanceStatus> STATUS_MAPPING = new HashMap<Status, InstanceInfo.InstanceStatus>(){
        {
            this.put(Status.UNKNOWN, InstanceInfo.InstanceStatus.UNKNOWN);
            this.put(Status.OUT_OF_SERVICE, InstanceInfo.InstanceStatus.OUT_OF_SERVICE);
            this.put(Status.DOWN, InstanceInfo.InstanceStatus.DOWN);
            this.put(Status.UP, InstanceInfo.InstanceStatus.UP);
        }
    };
    private StatusAggregator statusAggregator;
    private ApplicationContext applicationContext;
    private Map<String, HealthIndicator> healthIndicators;
    @Deprecated
    private CompositeHealthIndicator healthIndicator;
    @Deprecated
    private HealthIndicatorRegistryFactory healthIndicatorRegistryFactory;
    @Deprecated
    private HealthAggregator healthAggregator;

    @Deprecated
    public EurekaHealthCheckHandler(HealthAggregator healthAggregator) {
        Assert.notNull((Object)healthAggregator, (String)"HealthAggregator must not be null");
        this.healthAggregator = healthAggregator;
        this.healthIndicatorRegistryFactory = new HealthIndicatorRegistryFactory();
        this.healthIndicator = new CompositeHealthIndicator(this.healthAggregator, (HealthIndicatorRegistry)new DefaultHealthIndicatorRegistry());
    }

    public EurekaHealthCheckHandler(StatusAggregator statusAggregator) {
        this.statusAggregator = statusAggregator;
        Assert.notNull((Object)statusAggregator, (String)"StatusAggregator must not be null");
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        Map healthIndicators = this.applicationContext.getBeansOfType(HealthIndicator.class);
        this.healthIndicators = new HashMap<String, HealthIndicator>();
        if (this.statusAggregator != null) {
            this.populateHealthIndicators(healthIndicators);
        } else {
            this.createHealthIndicator(healthIndicators);
        }
    }

    @Deprecated
    void createHealthIndicator(Map<String, HealthIndicator> healthIndicators) {
        for (Map.Entry<String, HealthIndicator> entry : healthIndicators.entrySet()) {
            if (entry.getValue() instanceof DiscoveryCompositeHealthIndicator) {
                DiscoveryCompositeHealthIndicator indicator = (DiscoveryCompositeHealthIndicator)entry.getValue();
                for (DiscoveryCompositeHealthIndicator.Holder holder : indicator.getHealthIndicators()) {
                    if (holder.getDelegate() instanceof EurekaHealthIndicator) continue;
                    this.healthIndicators.put(holder.getDelegate().getName(), (HealthIndicator)holder);
                }
                continue;
            }
            this.healthIndicators.put(entry.getKey(), entry.getValue());
        }
        this.healthIndicator = new CompositeHealthIndicator(this.healthAggregator, this.healthIndicatorRegistryFactory.createHealthIndicatorRegistry(this.healthIndicators));
    }

    void populateHealthIndicators(Map<String, HealthIndicator> healthIndicators) {
        for (Map.Entry<String, HealthIndicator> entry : healthIndicators.entrySet()) {
            if (entry.getValue() instanceof DiscoveryCompositeHealthContributor) {
                DiscoveryCompositeHealthContributor indicator = (DiscoveryCompositeHealthContributor)entry.getValue();
                indicator.forEach(contributor -> {
                    if (!(contributor.getContributor() instanceof EurekaHealthIndicator)) {
                        this.healthIndicators.put(contributor.getName(), (HealthIndicator)contributor.getContributor());
                    }
                });
                continue;
            }
            this.healthIndicators.put(entry.getKey(), entry.getValue());
        }
    }

    public InstanceInfo.InstanceStatus getStatus(InstanceInfo.InstanceStatus instanceStatus) {
        return this.getHealthStatus();
    }

    protected InstanceInfo.InstanceStatus getHealthStatus() {
        Status status = this.statusAggregator != null ? this.getStatus(this.statusAggregator) : this.getStatus(this.getHealthIndicator());
        return this.mapToInstanceStatus(status);
    }

    @Deprecated
    private Status getStatus(CompositeHealthIndicator healthIndicator) {
        Status status = healthIndicator.health().getStatus();
        return status;
    }

    protected Status getStatus(StatusAggregator statusAggregator) {
        Set statusSet = this.healthIndicators.values().stream().map(HealthIndicator::health).map(Health::getStatus).collect(Collectors.toSet());
        Status status = statusAggregator.getAggregateStatus(statusSet);
        return status;
    }

    protected InstanceInfo.InstanceStatus mapToInstanceStatus(Status status) {
        if (!STATUS_MAPPING.containsKey(status)) {
            return InstanceInfo.InstanceStatus.UNKNOWN;
        }
        return STATUS_MAPPING.get(status);
    }

    @Deprecated
    protected CompositeHealthIndicator getHealthIndicator() {
        return this.healthIndicator;
    }
}

