/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka;

import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.EurekaClientConfig;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;

public class CloudEurekaClient
extends DiscoveryClient {
    private static final Log log = LogFactory.getLog(CloudEurekaClient.class);
    private final AtomicLong cacheRefreshedCount = new AtomicLong(0L);
    private ApplicationContext context;

    public CloudEurekaClient(ApplicationInfoManager applicationInfoManager, EurekaClientConfig config, ApplicationContext context) {
        this(applicationInfoManager, config, null, context);
    }

    public CloudEurekaClient(ApplicationInfoManager applicationInfoManager, EurekaClientConfig config, DiscoveryClient.DiscoveryClientOptionalArgs args, ApplicationContext context) {
        super(applicationInfoManager, config, args);
        this.context = context;
    }

    protected void onCacheRefreshed() {
        if (this.cacheRefreshedCount != null) {
            long newCount = this.cacheRefreshedCount.incrementAndGet();
            log.trace((Object)("onCacheRefreshed called with count: " + newCount));
            this.context.publishEvent((ApplicationEvent)new HeartbeatEvent((Object)this, (Object)newCount));
        }
    }
}

