/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.stats;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.CompletionContext;
import org.springframework.cloud.client.loadbalancer.LoadBalancerProperties;
import org.springframework.cloud.client.loadbalancer.RequestData;
import org.springframework.cloud.client.loadbalancer.RequestDataContext;
import org.springframework.cloud.client.loadbalancer.ResponseData;
import org.springframework.util.StringUtils;

class LoadBalancerTags {
    static final String UNKNOWN = "UNKNOWN";
    private final LoadBalancerProperties properties;
    private static final Set<String> URI_TEMPLATE_ATTRIBUTES = Set.of("org.springframework.web.reactive.function.client.WebClient.uriTemplate", "org.springframework.web.client.RestClient.uriTemplate");

    LoadBalancerTags(LoadBalancerProperties properties) {
        this.properties = properties;
    }

    Iterable<Tag> buildSuccessRequestTags(CompletionContext<Object, ServiceInstance, Object> completionContext) {
        ServiceInstance serviceInstance = (ServiceInstance)completionContext.getLoadBalancerResponse().getServer();
        Tags tags = Tags.of(LoadBalancerTags.buildServiceInstanceTags(serviceInstance));
        Object clientResponse = completionContext.getClientResponse();
        if (clientResponse instanceof ResponseData) {
            ResponseData responseData = (ResponseData)clientResponse;
            RequestData requestData = responseData.getRequestData();
            tags = requestData != null ? tags.and(new Tag[]{LoadBalancerTags.valueOrUnknown("method", requestData.getHttpMethod()), LoadBalancerTags.valueOrUnknown("uri", this.getPath(requestData))}) : tags.and(new Tag[]{Tag.of((String)"method", (String)UNKNOWN), Tag.of((String)"uri", (String)UNKNOWN)});
            tags = tags.and(new Tag[]{Tag.of((String)"outcome", (String)LoadBalancerTags.forStatus(LoadBalancerTags.statusValue(responseData))), LoadBalancerTags.valueOrUnknown("status", LoadBalancerTags.statusValue(responseData))});
        } else {
            tags = tags.and(new Tag[]{Tag.of((String)"method", (String)UNKNOWN), Tag.of((String)"uri", (String)UNKNOWN), Tag.of((String)"outcome", (String)UNKNOWN), Tag.of((String)"status", (String)UNKNOWN)});
        }
        return tags;
    }

    private static int statusValue(ResponseData responseData) {
        return responseData.getHttpStatus() != null ? responseData.getHttpStatus().value() : 200;
    }

    private String getPath(RequestData requestData) {
        if (!this.properties.getStats().isIncludePath()) {
            return UNKNOWN;
        }
        Optional<Object> uriTemplateValue = Optional.ofNullable(requestData.getAttributes()).orElse(Collections.emptyMap()).keySet().stream().filter(URI_TEMPLATE_ATTRIBUTES::contains).map(key -> requestData.getAttributes().get(key)).filter(Objects::nonNull).findAny();
        return uriTemplateValue.map(uriTemplate -> (String)uriTemplate).orElseGet(() -> requestData.getUrl() != null ? requestData.getUrl().getPath() : UNKNOWN);
    }

    Iterable<Tag> buildDiscardedRequestTags(CompletionContext<Object, ServiceInstance, Object> completionContext) {
        RequestData requestData;
        if (completionContext.getLoadBalancerRequest().getContext() instanceof RequestDataContext && (requestData = ((RequestDataContext)completionContext.getLoadBalancerRequest().getContext()).getClientRequest()) != null) {
            return Tags.of((Tag[])new Tag[]{LoadBalancerTags.valueOrUnknown("method", requestData.getHttpMethod()), LoadBalancerTags.valueOrUnknown("uri", this.getPath(requestData)), LoadBalancerTags.valueOrUnknown("serviceId", LoadBalancerTags.getHost(requestData))});
        }
        return Tags.of((Tag[])new Tag[]{LoadBalancerTags.valueOrUnknown("method", UNKNOWN), LoadBalancerTags.valueOrUnknown("uri", UNKNOWN), LoadBalancerTags.valueOrUnknown("serviceId", UNKNOWN)});
    }

    private static String getHost(RequestData requestData) {
        return requestData.getUrl() != null ? requestData.getUrl().getHost() : UNKNOWN;
    }

    Iterable<Tag> buildFailedRequestTags(CompletionContext<Object, ServiceInstance, Object> completionContext) {
        RequestData requestData;
        ServiceInstance serviceInstance = (ServiceInstance)completionContext.getLoadBalancerResponse().getServer();
        Tags tags = Tags.of(LoadBalancerTags.buildServiceInstanceTags(serviceInstance)).and(new Tag[]{LoadBalancerTags.exception(completionContext.getThrowable())});
        if (completionContext.getLoadBalancerRequest().getContext() instanceof RequestDataContext && (requestData = ((RequestDataContext)completionContext.getLoadBalancerRequest().getContext()).getClientRequest()) != null) {
            return tags.and((Iterable)Tags.of((Tag[])new Tag[]{LoadBalancerTags.valueOrUnknown("method", requestData.getHttpMethod()), LoadBalancerTags.valueOrUnknown("uri", this.getPath(requestData))}));
        }
        return tags.and((Iterable)Tags.of((Tag[])new Tag[]{LoadBalancerTags.valueOrUnknown("method", UNKNOWN), LoadBalancerTags.valueOrUnknown("uri", UNKNOWN)}));
    }

    static Iterable<Tag> buildServiceInstanceTags(ServiceInstance serviceInstance) {
        return Tags.of((Tag[])new Tag[]{LoadBalancerTags.valueOrUnknown("serviceId", serviceInstance.getServiceId()), LoadBalancerTags.valueOrUnknown("serviceInstance.instanceId", serviceInstance.getInstanceId()), LoadBalancerTags.valueOrUnknown("serviceInstance.host", serviceInstance.getHost()), LoadBalancerTags.valueOrUnknown("serviceInstance.port", String.valueOf(serviceInstance.getPort()))});
    }

    private static Tag valueOrUnknown(String key, String value) {
        if (value != null) {
            return Tag.of((String)key, (String)value);
        }
        return Tag.of((String)key, (String)UNKNOWN);
    }

    private static Tag valueOrUnknown(String key, Object value) {
        if (value != null) {
            return Tag.of((String)key, (String)String.valueOf(value));
        }
        return Tag.of((String)key, (String)UNKNOWN);
    }

    private static Tag exception(Throwable exception) {
        if (exception != null) {
            String simpleName = exception.getClass().getSimpleName();
            return Tag.of((String)"exception", (String)(StringUtils.hasText((String)simpleName) ? simpleName : exception.getClass().getName()));
        }
        return Tag.of((String)"exception", (String)"None");
    }

    public static String forStatus(int status) {
        if (status >= 100 && status < 200) {
            return "INFORMATIONAL";
        }
        if (status >= 200 && status < 300) {
            return "SUCCESS";
        }
        if (status >= 300 && status < 400) {
            return "REDIRECTION";
        }
        if (status >= 400 && status < 500) {
            return "CLIENT_ERROR";
        }
        if (status >= 500 && status < 600) {
            return "SERVER_ERROR";
        }
        return UNKNOWN;
    }
}

