/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.OAuth2AuthorizeRequest;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class TokenRelayGatewayFilterFactory
extends AbstractGatewayFilterFactory<AbstractGatewayFilterFactory.NameConfig> {
    private final ObjectProvider<ReactiveOAuth2AuthorizedClientManager> clientManagerProvider;

    public TokenRelayGatewayFilterFactory(ObjectProvider<ReactiveOAuth2AuthorizedClientManager> clientManagerProvider) {
        super(AbstractGatewayFilterFactory.NameConfig.class);
        this.clientManagerProvider = clientManagerProvider;
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Collections.singletonList("name");
    }

    public GatewayFilter apply() {
        return this.apply((AbstractGatewayFilterFactory.NameConfig)null);
    }

    @Override
    public GatewayFilter apply(AbstractGatewayFilterFactory.NameConfig config) {
        String defaultClientRegistrationId = config == null ? null : config.getName();
        return (exchange, chain) -> exchange.getPrincipal().filter(principal -> principal instanceof Authentication).cast(Authentication.class).flatMap(principal -> this.authorizationRequest(defaultClientRegistrationId, (Authentication)principal)).flatMap(this::authorizedClient).map(OAuth2AuthorizedClient::getAccessToken).map(token -> this.withBearerAuth(exchange, (OAuth2AccessToken)token)).defaultIfEmpty((Object)exchange).flatMap(chain::filter);
    }

    private Mono<OAuth2AuthorizeRequest> authorizationRequest(String defaultClientRegistrationId, Authentication principal) {
        String clientRegistrationId = defaultClientRegistrationId;
        if (clientRegistrationId == null && principal instanceof OAuth2AuthenticationToken) {
            clientRegistrationId = ((OAuth2AuthenticationToken)principal).getAuthorizedClientRegistrationId();
        }
        return Mono.justOrEmpty((Object)clientRegistrationId).map(OAuth2AuthorizeRequest::withClientRegistrationId).map(builder -> builder.principal(principal).build());
    }

    private Mono<OAuth2AuthorizedClient> authorizedClient(OAuth2AuthorizeRequest request) {
        ReactiveOAuth2AuthorizedClientManager clientManager = (ReactiveOAuth2AuthorizedClientManager)this.clientManagerProvider.getIfAvailable();
        if (clientManager == null) {
            return Mono.error((Throwable)new IllegalStateException("No ReactiveOAuth2AuthorizedClientManager bean was found. Did you include the org.springframework.boot:spring-boot-starter-oauth2-client dependency?"));
        }
        return clientManager.authorize(request);
    }

    private ServerWebExchange withBearerAuth(ServerWebExchange exchange, OAuth2AccessToken accessToken) {
        return exchange.mutate().request(r -> r.headers(headers -> headers.setBearerAuth(accessToken.getTokenValue()))).build();
    }
}

