/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.route;

import java.util.Map;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Flux;

public interface RouteLocator {
    public Flux<Route> getRoutes();

    default public Flux<Route> getRoutesByMetadata(Map<String, Object> metadata) {
        return this.getRoutes().filter(route -> RouteLocator.matchMetadata(route.getMetadata(), metadata));
    }

    public static boolean matchMetadata(Map<String, Object> toCheck, Map<String, Object> expectedMetadata) {
        if (CollectionUtils.isEmpty(expectedMetadata)) {
            return true;
        }
        return toCheck != null && expectedMetadata.entrySet().stream().allMatch(keyValue -> toCheck.containsKey(keyValue.getKey()) && toCheck.get(keyValue.getKey()).equals(keyValue.getValue()));
    }
}

