/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.observability;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import org.springframework.cloud.function.context.catalog.FunctionAroundWrapper;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.cloud.function.observability.DefaultFunctionObservationConvention;
import org.springframework.cloud.function.observability.FunctionContext;
import org.springframework.cloud.function.observability.FunctionObservation;
import org.springframework.cloud.function.observability.FunctionObservationConvention;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;

public class ObservationFunctionAroundWrapper
extends FunctionAroundWrapper {
    private final ObservationRegistry observationRegistry;
    private final FunctionObservationConvention functionObservationConvention;

    public ObservationFunctionAroundWrapper(ObservationRegistry observationRegistry, @Nullable FunctionObservationConvention functionObservationConvention) {
        this.observationRegistry = observationRegistry;
        this.functionObservationConvention = functionObservationConvention;
    }

    @Override
    protected Object doApply(Object message, SimpleFunctionRegistry.FunctionInvocationWrapper targetFunction) {
        return this.nonReactorStream((Message)message, targetFunction);
    }

    private Object nonReactorStream(Message<?> message, SimpleFunctionRegistry.FunctionInvocationWrapper targetFunction) {
        return this.functionProcessingObservation(targetFunction, message).observe(() -> targetFunction.apply(message));
    }

    private Observation functionProcessingObservation(SimpleFunctionRegistry.FunctionInvocationWrapper targetFunction, Message<?> message) {
        return FunctionObservation.FUNCTION_PROCESSING_OBSERVATION.observation(this.functionObservationConvention, DefaultFunctionObservationConvention.INSTANCE, () -> new FunctionContext(targetFunction, message), this.observationRegistry);
    }
}

