/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.config;

import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import org.springframework.cloud.function.cloudevent.CloudEventMessageUtils;
import org.springframework.cloud.function.json.JsonMapper;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.AbstractMessageConverter;
import org.springframework.util.MimeType;

public class JsonMessageConverter
extends AbstractMessageConverter {
    private final JsonMapper jsonMapper;

    public JsonMessageConverter(JsonMapper jsonMapper) {
        this(jsonMapper, new MimeType("application", "json"), new MimeType(CloudEventMessageUtils.APPLICATION_CLOUDEVENTS.getType(), CloudEventMessageUtils.APPLICATION_CLOUDEVENTS.getSubtype() + "+json"));
    }

    public JsonMessageConverter(JsonMapper jsonMapper, MimeType ... supportedMimeTypes) {
        super(supportedMimeTypes);
        this.jsonMapper = jsonMapper;
    }

    protected boolean supports(Class<?> clazz) {
        throw new UnsupportedOperationException();
    }

    protected boolean canConvertTo(Object payload, @Nullable MessageHeaders headers) {
        return this.supportsMimeType(headers);
    }

    protected boolean canConvertFrom(Message<?> message, @Nullable Class<?> targetClass) {
        return targetClass != null && this.supportsMimeType(message.getHeaders());
    }

    protected Object convertFromInternal(Message<?> message, Class<?> targetClass, @Nullable Object conversionHint) {
        Type convertToType;
        Type type = convertToType = conversionHint == null ? targetClass : (Type)conversionHint;
        if (targetClass == byte[].class && message.getPayload() instanceof String) {
            return ((String)message.getPayload()).getBytes(StandardCharsets.UTF_8);
        }
        try {
            return this.jsonMapper.fromJson(message.getPayload(), convertToType);
        }
        catch (Exception e) {
            if (message.getPayload() instanceof byte[] && targetClass.isAssignableFrom(String.class)) {
                return new String((byte[])message.getPayload(), StandardCharsets.UTF_8);
            }
            if (this.logger.isDebugEnabled()) {
                Object payload = message.getPayload();
                if (payload instanceof byte[]) {
                    payload = new String((byte[])payload, StandardCharsets.UTF_8);
                }
                this.logger.warn((Object)("Failed to convert value: " + payload), (Throwable)e);
            }
            return null;
        }
    }

    protected Object convertToInternal(Object payload, @Nullable MessageHeaders headers, @Nullable Object conversionHint) {
        return this.jsonMapper.toJson(payload);
    }
}

