/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;

@ConfigurationProperties(prefix="spring.cloud.function")
public class FunctionProperties
implements EnvironmentAware,
ApplicationContextAware {
    public static final String PREFIX = "spring.cloud.function";
    @Deprecated
    public static final String SKIP_CONVERSION_HEADER = "skip-input-type-conversion";
    public static final String EXPECT_CONTENT_TYPE_HEADER = "expected-content-type";
    public static final String ROUTING_EXPRESSION = "spring.cloud.function.routing-expression";
    public static final String FUNCTION_DEFINITION = "spring.cloud.function.definition";
    private String definition;
    private String routingExpression;
    private final List<String> ineligibleDefinitions = new ArrayList<String>();
    private Map<String, FunctionConfigurationProperties> configuration;
    private String expectedContentType;
    private Environment environment;
    private ApplicationContext applicationContext;

    public FunctionProperties() {
        String[] definitions = new String[]{"org.springframework.boot", "org.springframework.cloud.function.cloudevent.CloudEventsFunctionExtensionConfiguration", "org.springframework.cloud.function.context.config.FunctionsEndpointAutoConfiguration", "classLoaderMetrics", "jvmMemoryMetrics", "jvmInfoMetrics", "jvmCompilationMetrics", "uptimeMetrics", "kotlinToFunctionTransformer", "CloudEventsMessageConverterConfiguration"};
        this.ineligibleDefinitions.addAll(Arrays.asList(definitions));
    }

    public Map<String, FunctionConfigurationProperties> getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Map<String, FunctionConfigurationProperties> configuration) {
        block0: for (Map.Entry<String, FunctionConfigurationProperties> entry : configuration.entrySet()) {
            Map<String, Object> current;
            String propertyX = "spring.cloud.function.configuration." + entry.getKey() + ".input-header-mapping-expression.";
            String propertyY = "spring.cloud.function.configuration." + entry.getKey() + ".inputHeaderMappingExpression.";
            Map<String, Object> headerMapping = entry.getValue().getInputHeaderMappingExpression();
            if (!CollectionUtils.isEmpty(headerMapping)) {
                for (String k : headerMapping.keySet()) {
                    if (!this.environment.containsProperty(propertyX + k) && !this.environment.containsProperty(propertyY + k)) continue;
                    current = entry.getValue().getInputHeaderMappingExpression();
                    if (current.containsKey("0")) {
                        ((Map)current.get("0")).put(k, headerMapping.get(k));
                        continue;
                    }
                    entry.getValue().setInputHeaderMappingExpression(Collections.singletonMap("0", current));
                    break;
                }
            }
            propertyX = "spring.cloud.function.configuration." + entry.getKey() + ".output-header-mapping-expression.";
            propertyY = "spring.cloud.function.configuration." + entry.getKey() + ".outputHeaderMappingExpression.";
            headerMapping = entry.getValue().getOutputHeaderMappingExpression();
            if (CollectionUtils.isEmpty(headerMapping)) continue;
            for (String k : headerMapping.keySet()) {
                if (!this.environment.containsProperty(propertyX + k) && !this.environment.containsProperty(propertyY + k)) continue;
                current = entry.getValue().getOutputHeaderMappingExpression();
                if (current.containsKey("0")) {
                    ((Map)current.get("0")).put(k, headerMapping.get(k));
                    continue;
                }
                entry.getValue().setOutputHeaderMappingExpression(Collections.singletonMap("0", current));
                continue block0;
            }
        }
        this.configuration = configuration;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public String getDefinition() {
        return this.definition;
    }

    public void setDefinition(String definition) {
        this.definition = definition;
    }

    public String getRoutingExpression() {
        return this.routingExpression;
    }

    public void setRoutingExpression(String routingExpression) {
        this.routingExpression = routingExpression;
    }

    public String getExpectedContentType() {
        return this.expectedContentType;
    }

    public void setExpectedContentType(String expectedContentType) {
        this.expectedContentType = expectedContentType;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public List<String> getIneligibleDefinitions() {
        return new ArrayList<String>(this.ineligibleDefinitions);
    }

    public void setIneligibleDefinitions(List<String> definitions) {
        this.ineligibleDefinitions.addAll(definitions);
    }

    public static class FunctionConfigurationProperties {
        private Map<String, Object> inputHeaderMappingExpression;
        private Map<String, Object> outputHeaderMappingExpression;
        private boolean copyInputHeaders;

        public Map<String, Object> getInputHeaderMappingExpression() {
            return this.inputHeaderMappingExpression;
        }

        public void setInputHeaderMappingExpression(Map<String, Object> inputHeaderMappingExpression) {
            this.inputHeaderMappingExpression = inputHeaderMappingExpression;
        }

        public Map<String, Object> getOutputHeaderMappingExpression() {
            return this.outputHeaderMappingExpression;
        }

        public void setOutputHeaderMappingExpression(Map<String, Object> outputHeaderMappingExpression) {
            this.outputHeaderMappingExpression = outputHeaderMappingExpression;
        }

        public boolean isCopyInputHeaders() {
            return this.copyInputHeaders;
        }

        public void setCopyInputHeaders(boolean copyInputHeaders) {
            this.copyInputHeaders = copyInputHeaders;
        }
    }
}

