/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.file;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.io.File;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.spec.ContractConverter;
import org.springframework.cloud.contract.verifier.converter.YamlContractConverter;
import org.springframework.cloud.contract.verifier.file.ContractMetadata;
import org.springframework.cloud.contract.verifier.util.ContractVerifierDslConverter;
import org.springframework.core.io.support.SpringFactoriesLoader;
import wiremock.com.google.common.collect.ArrayListMultimap;
import wiremock.com.google.common.collect.ListMultimap;

public class ContractFileScanner
implements GroovyObject {
    private static final String OS_NAME;
    private static final String OS_NAME_WINDOWS_PREFIX = "Windows";
    protected static final boolean IS_OS_WINDOWS;
    private static final String MATCH_PREFIX = "glob:";
    private static final Pattern SCENARIO_STEP_FILENAME_PATTERN;
    private final File baseDir;
    private final Set<PathMatcher> excludeMatchers;
    private final Set<PathMatcher> ignoreMatchers;
    private final String includeMatcher;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public ContractFileScanner(File baseDir, Set<String> excluded, Set<String> ignored, String includeMatcher) {
        String string;
        File file;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.baseDir = file = baseDir;
        Set set = excluded;
        Set<PathMatcher> set2 = this.processPatterns(DefaultTypeTransformation.booleanUnbox(set) ? set : (Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class));
        this.excludeMatchers = set2;
        Set set3 = ignored;
        Set<PathMatcher> set4 = this.processPatterns(DefaultTypeTransformation.booleanUnbox(set3) ? set3 : (Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class));
        this.ignoreMatchers = set4;
        this.includeMatcher = string = includeMatcher;
    }

    public ContractFileScanner(File baseDir, Set<String> excluded, Set<String> ignored) {
        this(baseDir, excluded, ignored, "");
    }

    private Set<PathMatcher> processPatterns(Set<String> patterns) {
        Reference fileSystem = new Reference((Object)FileSystems.getDefault());
        public class _processPatterns_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference fileSystem;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _processPatterns_closure1(Object _outerInstance, Object _thisObject, Reference fileSystem) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.fileSystem = reference = fileSystem;
            }

            public Object doCall(Object it) {
                String syntaxAndPattern = StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)MATCH_PREFIX, (CharSequence)"**"), (CharSequence)File.separator), (CharSequence)((CharSequence)ScriptBytecodeAdapter.castToType((Object)it, CharSequence.class)));
                if (IS_OS_WINDOWS) {
                    String string;
                    syntaxAndPattern = string = syntaxAndPattern.replace("\\", "\\\\");
                }
                return ((FileSystem)this.fileSystem.get()).getPathMatcher(syntaxAndPattern);
            }

            public FileSystem getFileSystem() {
                return (FileSystem)ScriptBytecodeAdapter.castToType((Object)this.fileSystem.get(), FileSystem.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _processPatterns_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return (Set)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.collect(patterns, (Closure)new _processPatterns_closure1(this, this, fileSystem)), Set.class);
    }

    public ListMultimap<Path, ContractMetadata> findContracts() {
        ArrayListMultimap result = ArrayListMultimap.create();
        this.appendRecursively(this.baseDir, (ListMultimap<Path, ContractMetadata>)result);
        return result;
    }

    private void appendRecursively(File baseDir, ListMultimap<Path, ContractMetadata> result) {
        List<ContractConverter> converters = this.converters();
        if (log.isTraceEnabled()) {
            Object v0;
            if (log.isTraceEnabled()) {
                log.trace(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{converters}, new String[]{"Found the following contract converters ", ""})));
                v0 = null;
            } else {
                v0 = null;
            }
        }
        File[] files = baseDir.listFiles();
        if (!DefaultTypeTransformation.booleanUnbox((Object)files)) {
            return;
        }
        Object[] sortedFiles = (File[])DefaultGroovyMethods.sort((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)files, Object[].class)));
        int i = 0;
        while (i < sortedFiles.length) {
            File file = (File)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])sortedFiles, (int)i), File.class);
            boolean excluded = this.matchesPattern(file, this.excludeMatchers);
            if (!excluded) {
                boolean contractFile = this.isContractFile(file);
                boolean included = DefaultTypeTransformation.booleanUnbox((Object)this.includeMatcher) ? file.getAbsolutePath().matches(this.includeMatcher) : true;
                if (contractFile && included) {
                    this.addContractToTestGeneration(result, files, file, i, ContractVerifierDslConverter.convertAsCollection(baseDir, file));
                } else if (YamlContractConverter.INSTANCE.isAccepted(file) && included) {
                    this.addContractToTestGeneration(result, files, file, i, YamlContractConverter.INSTANCE.convertFrom(file));
                } else if (!contractFile && included) {
                    this.addContractToTestGeneration(converters, result, files, file, i);
                } else {
                    this.appendRecursively(file, result);
                    if (log.isDebugEnabled()) {
                        Object v1;
                        if (log.isDebugEnabled()) {
                            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{file, contractFile, included}, new String[]{"File [", "] is ignored. Is a contract file? [", "]. Should be included by pattern? [", "]"})));
                            v1 = null;
                        } else {
                            v1 = null;
                        }
                    }
                }
            } else if (log.isDebugEnabled()) {
                Object v2;
                if (log.isDebugEnabled()) {
                    log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{file, excluded}, new String[]{"File [", "] is ignored. Should be excluded? [", "]"})));
                    v2 = null;
                } else {
                    v2 = null;
                }
            }
            int n = i;
            int cfr_ignored_0 = n + 1;
        }
    }

    protected List<ContractConverter> converters() {
        return SpringFactoriesLoader.loadFactories(ContractConverter.class, null);
    }

    private void addContractToTestGeneration(List<ContractConverter> converters, ListMultimap<Path, ContractMetadata> result, File[] files, File file, int index) {
        boolean converted = false;
        if (!file.isDirectory()) {
            ContractConverter converter = null;
            Iterator<ContractConverter> iterator = converters.iterator();
            while (iterator.hasNext()) {
                boolean bl;
                converter = (ContractConverter)ScriptBytecodeAdapter.castToType((Object)iterator.next(), ContractConverter.class);
                Collection<Contract> contracts = this.tryConvert(converter, file);
                if (!DefaultTypeTransformation.booleanUnbox(contracts)) continue;
                this.addContractToTestGeneration(result, files, file, index, contracts);
                converted = bl = true;
                break;
            }
        }
        if (!converted) {
            this.appendRecursively(file, result);
            if (log.isDebugEnabled()) {
                Object v0;
                if (log.isDebugEnabled()) {
                    log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{file, file.isDirectory()}, new String[]{"File [", "] wasn't ignored but no converter was applicable. The file is a directory [", "]"})));
                    v0 = null;
                } else {
                    v0 = null;
                }
            }
        }
    }

    private Collection<Contract> tryConvert(ContractConverter converter, File file) {
        boolean accepted = converter.isAccepted(file);
        if (!accepted) {
            return (Collection)ScriptBytecodeAdapter.castToType(null, Collection.class);
        }
        Collection collection = converter.convertFrom(file);
        try {
            return collection;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Exception occurred while trying to convert the file", (Throwable)e);
            }
            Collection collection2 = (Collection)ScriptBytecodeAdapter.castToType(null, Collection.class);
            return collection2;
        }
    }

    private void addContractToTestGeneration(ListMultimap<Path, ContractMetadata> result, File[] files, File file, int index, Collection<Contract> convertedContract) {
        Path path = file.toPath();
        Integer order = null;
        if (this.hasScenarioFilenamePattern(path)) {
            int n = index;
            order = n;
        }
        Path parent = file.getParentFile().toPath();
        ContractMetadata metadata = new ContractMetadata(path, this.matchesPattern(file, this.ignoreMatchers), DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)files, Object[].class))), order, convertedContract);
        if (log.isDebugEnabled()) {
            Object v0;
            if (log.isDebugEnabled()) {
                log.debug(StringGroovyMethods.plus((String)StringGroovyMethods.plus((CharSequence)StringGroovyMethods.plus((String)StringGroovyMethods.plus((CharSequence)"Creating a contract entry for path [", (Object)path), (CharSequence)"] and metadata ["), (Object)metadata), (CharSequence)"]"));
                v0 = null;
            } else {
                v0 = null;
            }
        }
        if (DefaultTypeTransformation.booleanUnbox(convertedContract)) {
            // empty if block
        }
        result.put((Object)parent, (Object)metadata);
    }

    private boolean hasScenarioFilenamePattern(Path path) {
        return SCENARIO_STEP_FILENAME_PATTERN.matcher(path.getFileName().toString()).matches();
    }

    private boolean matchesPattern(File file, Set<PathMatcher> matchers) {
        PathMatcher matcher = null;
        Iterator<PathMatcher> iterator = matchers.iterator();
        while (iterator.hasNext()) {
            Object v0;
            matcher = (PathMatcher)ScriptBytecodeAdapter.castToType((Object)iterator.next(), PathMatcher.class);
            if (matcher.matches(file.toPath())) {
                return true;
            }
            if (log.isDebugEnabled()) {
                log.debug("Path [{}] doesn't match the pattern [{}]", (Object)file.toPath(), (Object)matcher);
                v0 = null;
                continue;
            }
            v0 = null;
        }
        return false;
    }

    private boolean isContractFile(File file) {
        String string;
        return file.isFile() && DefaultTypeTransformation.booleanUnbox((string = ContractFileScanner.getFilenameExtension(file.toString())) != null ? Boolean.valueOf(string.equalsIgnoreCase("groovy")) : null);
    }

    private static String getFilenameExtension(String path) {
        if (path == null) {
            return ShortTypeHandling.castToString(null);
        }
        int extIndex = path.lastIndexOf(".");
        if (ScriptBytecodeAdapter.compareEqual((Object)extIndex, (Object)-1)) {
            return ShortTypeHandling.castToString(null);
        }
        int folderIndex = path.lastIndexOf("/");
        if (folderIndex > extIndex) {
            return ShortTypeHandling.castToString(null);
        }
        return path.substring(extIndex + 1);
    }

    private static boolean getOSMatchesName(String osNamePrefix) {
        return ContractFileScanner.isOSNameMatch(OS_NAME, osNamePrefix);
    }

    private static boolean isOSNameMatch(String osName, String osNamePrefix) {
        if (osName == null) {
            return false;
        }
        return osName.startsWith(osNamePrefix);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ContractFileScanner.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        Pattern pattern;
        boolean bl;
        String string;
        OS_NAME = string = System.getProperty("os.name");
        IS_OS_WINDOWS = bl = ContractFileScanner.getOSMatchesName(OS_NAME_WINDOWS_PREFIX);
        SCENARIO_STEP_FILENAME_PATTERN = pattern = Pattern.compile("[0-9]+_.*");
        log = logger = LoggerFactory.getLogger((String)"org.springframework.cloud.contract.verifier.file.ContractFileScanner");
    }
}

