/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.messaging.stream;

import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.stubrunner.BatchStubRunner;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;
import org.springframework.cloud.contract.stubrunner.messaging.integration.StubRunnerIntegrationConfiguration;
import org.springframework.cloud.contract.stubrunner.messaging.stream.StubRunnerStreamMessageSelector;
import org.springframework.cloud.contract.stubrunner.messaging.stream.StubRunnerStreamTransformer;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.binding.BinderAwareChannelResolver;
import org.springframework.cloud.stream.config.BindingProperties;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.context.Lifecycle;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.core.GenericSelector;
import org.springframework.integration.dsl.FilterEndpointSpec;
import org.springframework.integration.dsl.GenericEndpointSpec;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.IntegrationFlows;
import org.springframework.integration.transformer.GenericTransformer;
import org.springframework.integration.transformer.MessageTransformingHandler;
import org.springframework.messaging.Message;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={IntegrationFlows.class, EnableBinding.class})
@ConditionalOnProperty(name={"stubrunner.stream.enabled"}, havingValue="true", matchIfMissing=true)
@AutoConfigureBefore(value={StubRunnerIntegrationConfiguration.class})
public class StubRunnerStreamConfiguration {
    private static final Log log = LogFactory.getLog(StubRunnerStreamConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(name={"stubFlowRegistrar"})
    @ConditionalOnBean(value={BindingServiceProperties.class})
    public FlowRegistrar stubFlowRegistrar(AutowireCapableBeanFactory beanFactory, BatchStubRunner batchStubRunner) {
        Map<StubConfiguration, Collection<Contract>> contracts = batchStubRunner.getContracts();
        for (Map.Entry<StubConfiguration, Collection<Contract>> entry : contracts.entrySet()) {
            StubConfiguration key = entry.getKey();
            Collection<Contract> value = entry.getValue();
            String name = key.getGroupId() + "_" + key.getArtifactId();
            for (Contract dsl : value) {
                if (dsl == null) continue;
                if (dsl.getInput() != null && dsl.getInput().getMessageFrom() != null && StringUtils.hasText((String)((String)dsl.getInput().getMessageFrom().getClientValue()))) {
                    final String flowName = name + "_" + dsl.getLabel() + "_" + dsl.hashCode();
                    String from = this.resolvedDestination(beanFactory, (String)dsl.getInput().getMessageFrom().getClientValue());
                    IntegrationFlowBuilder builder = (IntegrationFlowBuilder)((IntegrationFlowBuilder)IntegrationFlows.from((String)from).filter((GenericSelector)new StubRunnerStreamMessageSelector(dsl), (Consumer)new Consumer<FilterEndpointSpec>(){

                        @Override
                        public void accept(FilterEndpointSpec e) {
                            e.id(flowName + ".filter");
                        }
                    })).transform((GenericTransformer)new StubRunnerStreamTransformer(dsl), (Consumer)new Consumer<GenericEndpointSpec<MessageTransformingHandler>>(){

                        @Override
                        public void accept(GenericEndpointSpec<MessageTransformingHandler> e) {
                            e.id(flowName + ".transformer");
                        }
                    });
                    builder = dsl.getOutputMessage() != null && dsl.getOutputMessage().getSentTo() != null ? (IntegrationFlowBuilder)builder.channel(this.resolvedDestination(beanFactory, (String)dsl.getOutputMessage().getSentTo().getClientValue())) : (IntegrationFlowBuilder)builder.handle((Object)new DummyMessageHandler(), "handle");
                    beanFactory.initializeBean((Object)builder.get(), flowName);
                    ((Lifecycle)beanFactory.getBean(flowName + ".filter", Lifecycle.class)).start();
                    ((Lifecycle)beanFactory.getBean(flowName + ".transformer", Lifecycle.class)).start();
                    continue;
                }
                if (dsl.getOutputMessage() == null || dsl.getOutputMessage().getSentTo() == null || !StringUtils.hasText((String)((String)dsl.getOutputMessage().getSentTo().getClientValue()))) continue;
                BinderAwareChannelResolver resolver = (BinderAwareChannelResolver)beanFactory.getBean(BinderAwareChannelResolver.class);
                resolver.resolveDestination((String)dsl.getOutputMessage().getSentTo().getClientValue());
            }
        }
        return new FlowRegistrar();
    }

    private String resolvedDestination(AutowireCapableBeanFactory context, String destination) {
        Map<String, BindingProperties> bindings = this.bindingProperties(context);
        for (Map.Entry<String, BindingProperties> entry : bindings.entrySet()) {
            if (!destination.equals(entry.getValue().getDestination())) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found a channel named [" + entry.getKey() + "] with destination [" + destination + "]"));
            }
            return entry.getKey();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("No destination named [" + destination + "] was found. Assuming that the destination equals the channel name"));
        }
        return destination;
    }

    private Map<String, BindingProperties> bindingProperties(AutowireCapableBeanFactory context) {
        return ((BindingServiceProperties)context.getBean(BindingServiceProperties.class)).getBindings();
    }

    static class FlowRegistrar {
        FlowRegistrar() {
        }
    }

    private static class DummyMessageHandler {
        private DummyMessageHandler() {
        }

        public void handle(Message<?> message) {
        }
    }
}

