/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.junit;

import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.stubrunner.BatchStubRunner;
import org.springframework.cloud.contract.stubrunner.BatchStubRunnerFactory;
import org.springframework.cloud.contract.stubrunner.RunningStubs;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;
import org.springframework.cloud.contract.stubrunner.StubFinder;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptions;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptionsBuilder;
import org.springframework.cloud.contract.stubrunner.junit.PortStubRunnerRuleOptions;
import org.springframework.cloud.contract.stubrunner.junit.StubRunnerRuleOptions;
import org.springframework.cloud.contract.stubrunner.spring.StubRunnerProperties;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifier;

public class StubRunnerRule
implements TestRule,
StubFinder,
StubRunnerRuleOptions {
    private static final String DELIMITER = ":";
    private static final String LATEST_VERSION = "+";
    StubRunnerOptionsBuilder stubRunnerOptionsBuilder = new StubRunnerOptionsBuilder(StubRunnerOptions.fromSystemProps());
    BatchStubRunner stubFinder;
    MessageVerifier verifier = new ExceptionThrowingMessageVerifier();
    StubRunnerRule delegate = this;

    public StubRunnerRule() {
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                this.before();
                base.evaluate();
                StubRunnerRule.this.stubFinder().close();
            }

            private void before() {
                StubRunnerRule.this.stubFinder(new BatchStubRunnerFactory(StubRunnerRule.this.builder().build(), StubRunnerRule.this.verifier()).buildBatchStubRunner());
                StubRunnerRule.this.stubFinder().runStubs();
            }
        };
    }

    @Override
    public StubRunnerRule messageVerifier(MessageVerifier messageVerifier) {
        this.verifier(messageVerifier);
        return this.delegate;
    }

    @Override
    public StubRunnerRule options(StubRunnerOptions stubRunnerOptions) {
        this.builder().withOptions(stubRunnerOptions);
        return this.delegate;
    }

    @Override
    public StubRunnerRule minPort(int minPort) {
        this.builder().withMinPort(minPort);
        return this.delegate;
    }

    @Override
    public StubRunnerRule maxPort(int maxPort) {
        this.builder().withMaxPort(maxPort);
        return this.delegate;
    }

    @Override
    public StubRunnerRule repoRoot(String repoRoot) {
        this.builder().withStubRepositoryRoot(repoRoot);
        return this.delegate;
    }

    @Override
    public StubRunnerRule stubsMode(StubRunnerProperties.StubsMode stubsMode) {
        this.builder().withStubsMode(stubsMode);
        return this.delegate;
    }

    @Override
    public PortStubRunnerRule downloadStub(String groupId, String artifactId, String version, String classifier) {
        this.builder().withStubs(groupId + DELIMITER + artifactId + DELIMITER + version + DELIMITER + classifier);
        return new PortStubRunnerRule(this.delegate);
    }

    @Override
    public PortStubRunnerRule downloadLatestStub(String groupId, String artifactId, String classifier) {
        this.builder().withStubs(groupId + DELIMITER + artifactId + DELIMITER + LATEST_VERSION + DELIMITER + classifier);
        return new PortStubRunnerRule(this.delegate);
    }

    @Override
    public PortStubRunnerRule downloadStub(String groupId, String artifactId, String version) {
        this.builder().withStubs(groupId + DELIMITER + artifactId + DELIMITER + version);
        return new PortStubRunnerRule(this.delegate);
    }

    @Override
    public PortStubRunnerRule downloadStub(String groupId, String artifactId) {
        this.builder().withStubs(groupId + DELIMITER + artifactId);
        return new PortStubRunnerRule(this.delegate);
    }

    @Override
    public PortStubRunnerRule downloadStub(String ivyNotation) {
        this.builder().withStubs(ivyNotation);
        return new PortStubRunnerRule(this.delegate);
    }

    @Override
    public StubRunnerRule downloadStubs(String ... ivyNotations) {
        this.builder().withStubs(Arrays.asList(ivyNotations));
        return new PortStubRunnerRule(this.delegate);
    }

    @Override
    public StubRunnerRule downloadStubs(List<String> ivyNotations) {
        this.builder().withStubs(ivyNotations);
        return new PortStubRunnerRule(this.delegate);
    }

    @Override
    public StubRunnerRule withStubPerConsumer(boolean stubPerConsumer) {
        this.builder().withStubPerConsumer(stubPerConsumer);
        return this.delegate;
    }

    @Override
    public StubRunnerRule withConsumerName(String consumerName) {
        this.builder().withConsumerName(consumerName);
        return this.delegate;
    }

    @Override
    public StubRunnerRule withMappingsOutputFolder(String mappingsOutputFolder) {
        this.builder().withMappingsOutputFolder(mappingsOutputFolder);
        return this.delegate;
    }

    @Override
    public StubRunnerRule withSnapshotCheckSkip(boolean snapshotCheckSkip) {
        this.builder().withSnapshotCheckSkip(snapshotCheckSkip);
        return this.delegate;
    }

    @Override
    public StubRunnerRule withDeleteStubsAfterTest(boolean deleteStubsAfterTest) {
        this.builder().withDeleteStubsAfterTest(deleteStubsAfterTest);
        return this.delegate;
    }

    @Override
    public StubRunnerRule withProperties(Map<String, String> properties) {
        this.builder().withProperties(properties);
        return this.delegate;
    }

    @Override
    public URL findStubUrl(String groupId, String artifactId) {
        return this.stubFinder().findStubUrl(groupId, artifactId);
    }

    @Override
    public URL findStubUrl(String ivyNotation) {
        return this.stubFinder().findStubUrl(ivyNotation);
    }

    @Override
    public RunningStubs findAllRunningStubs() {
        return this.stubFinder().findAllRunningStubs();
    }

    @Override
    public Map<StubConfiguration, Collection<Contract>> getContracts() {
        return this.stubFinder().getContracts();
    }

    @Override
    public boolean trigger(String ivyNotation, String labelName) {
        boolean result = this.stubFinder().trigger(ivyNotation, labelName);
        if (!result) {
            throw new IllegalStateException("Failed to trigger a message with notation [" + ivyNotation + "] and label [" + labelName + "]");
        }
        return result;
    }

    @Override
    public boolean trigger(String labelName) {
        boolean result = this.stubFinder().trigger(labelName);
        if (!result) {
            throw new IllegalStateException("Failed to trigger a message with label [" + labelName + "]");
        }
        return result;
    }

    @Override
    public boolean trigger() {
        boolean result = this.stubFinder().trigger();
        if (!result) {
            throw new IllegalStateException("Failed to trigger a message");
        }
        return result;
    }

    @Override
    public Map<String, Collection<String>> labels() {
        return this.stubFinder().labels();
    }

    StubRunnerRule(StubRunnerRule delegate) {
        this.delegate = delegate;
    }

    BatchStubRunner stubFinder() {
        return this.delegate.stubFinder;
    }

    void stubFinder(BatchStubRunner stubFinder) {
        this.delegate.stubFinder = stubFinder;
    }

    MessageVerifier verifier() {
        return this.delegate.verifier;
    }

    void verifier(MessageVerifier verifier) {
        this.delegate.verifier = verifier;
    }

    StubRunnerOptionsBuilder builder() {
        return this.delegate.stubRunnerOptionsBuilder;
    }

    public static class PortStubRunnerRule
    extends StubRunnerRule
    implements PortStubRunnerRuleOptions {
        PortStubRunnerRule(StubRunnerRule delegate) {
            super(delegate);
        }

        @Override
        public StubRunnerRule withPort(Integer port) {
            this.builder().withPort(port);
            return this.delegate;
        }
    }

    static class ExceptionThrowingMessageVerifier
    implements MessageVerifier {
        private static final String EXCEPTION_MESSAGE = "Please provide a custom MessageVerifier to use this feature";

        ExceptionThrowingMessageVerifier() {
        }

        public void send(Object message, String destination) {
            throw new UnsupportedOperationException(EXCEPTION_MESSAGE);
        }

        public Object receive(String destination, long timeout, TimeUnit timeUnit) {
            throw new UnsupportedOperationException(EXCEPTION_MESSAGE);
        }

        public Object receive(String destination) {
            throw new UnsupportedOperationException(EXCEPTION_MESSAGE);
        }

        public void send(Object payload, Map headers, String destination) {
            throw new UnsupportedOperationException(EXCEPTION_MESSAGE);
        }
    }
}

