/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.context.scope.thread;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.cloud.context.scope.ScopeCache;

public class ThreadLocalScopeCache
implements ScopeCache {
    private ThreadLocal<ConcurrentMap<String, Object>> data = new ThreadLocal<ConcurrentMap<String, Object>>(){

        @Override
        protected ConcurrentMap<String, Object> initialValue() {
            return new ConcurrentHashMap<String, Object>();
        }
    };

    @Override
    public Object remove(String name) {
        return this.data.get().remove(name);
    }

    @Override
    public Collection<Object> clear() {
        ConcurrentMap<String, Object> map = this.data.get();
        ArrayList<Object> values = new ArrayList<Object>(map.values());
        map.clear();
        return values;
    }

    @Override
    public Object get(String name) {
        return this.data.get().get(name);
    }

    @Override
    public Object put(String name, Object value) {
        Object result = this.data.get().putIfAbsent(name, value);
        if (result != null) {
            return result;
        }
        return value;
    }
}

