/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client;

import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.cloud.client.ServiceInstance;

public class DefaultServiceInstance
implements ServiceInstance {
    private String instanceId;
    private String serviceId;
    private String host;
    private int port;
    private boolean secure;
    private Map<String, String> metadata = new LinkedHashMap<String, String>();
    private URI uri;

    public DefaultServiceInstance(String instanceId, String serviceId, String host, int port, boolean secure, Map<String, String> metadata) {
        this.instanceId = instanceId;
        this.serviceId = serviceId;
        this.host = host;
        this.port = port;
        this.secure = secure;
        this.metadata = metadata;
    }

    public DefaultServiceInstance(String instanceId, String serviceId, String host, int port, boolean secure) {
        this(instanceId, serviceId, host, port, secure, new LinkedHashMap<String, String>());
    }

    public DefaultServiceInstance() {
    }

    public static URI getUri(ServiceInstance instance) {
        String scheme = instance.isSecure() ? "https" : "http";
        int port = instance.getPort();
        if (port <= 0) {
            port = instance.isSecure() ? 443 : 80;
        }
        String uri = String.format("%s://%s:%s", scheme, instance.getHost(), port);
        return URI.create(uri);
    }

    @Override
    public URI getUri() {
        return DefaultServiceInstance.getUri(this);
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Override
    public String getInstanceId() {
        return this.instanceId;
    }

    @Override
    public String getServiceId() {
        return this.serviceId;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public void setUri(URI uri) {
        this.uri = uri;
        this.host = this.uri.getHost();
        this.port = this.uri.getPort();
        String scheme = this.uri.getScheme();
        if ("https".equals(scheme)) {
            this.secure = true;
        }
    }

    public String toString() {
        return "DefaultServiceInstance{instanceId='" + this.instanceId + "', serviceId='" + this.serviceId + "', host='" + this.host + "', port=" + this.port + ", secure=" + this.secure + ", metadata=" + this.metadata + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultServiceInstance that = (DefaultServiceInstance)o;
        return this.port == that.port && this.secure == that.secure && Objects.equals(this.instanceId, that.instanceId) && Objects.equals(this.serviceId, that.serviceId) && Objects.equals(this.host, that.host) && Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.instanceId, this.serviceId, this.host, this.port, this.secure, this.metadata);
    }
}

