/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer.reactive;

import java.net.URI;
import java.util.List;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.reactive.LoadBalancerClientRequestTransformer;
import org.springframework.http.HttpMethod;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.ClientRequest;

public final class ExchangeFilterFunctionUtils {
    private ExchangeFilterFunctionUtils() {
        throw new IllegalStateException("Can't instantiate a utility class.");
    }

    static ClientRequest buildClientRequest(ClientRequest request, URI uri, ServiceInstance serviceInstance, List<LoadBalancerClientRequestTransformer> transformers) {
        ClientRequest clientRequest = ClientRequest.create((HttpMethod)request.method(), (URI)uri).headers(headers -> headers.addAll((MultiValueMap)request.headers())).cookies(cookies -> cookies.addAll(request.cookies())).attributes(attributes -> attributes.putAll(request.attributes())).body(request.body()).build();
        if (transformers != null) {
            for (LoadBalancerClientRequestTransformer transformer : transformers) {
                clientRequest = transformer.transformRequest(clientRequest, serviceInstance);
            }
        }
        return clientRequest;
    }
}

