/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.commons.util;

import java.io.Closeable;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.commons.util.InetUtilsProperties;

public class InetUtils
implements Closeable {
    private static final Log log = LogFactory.getLog(InetUtils.class);
    private static ExecutorService executorService;
    private final InetUtilsProperties properties;
    private static final InetUtils instance;

    public InetUtils(InetUtilsProperties properties) {
        this.properties = properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void close() {
        if (executorService == null) return;
        Class<InetUtils> clazz = InetUtils.class;
        synchronized (InetUtils.class) {
            if (executorService == null) return;
            executorService.shutdown();
            executorService = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ExecutorService getExecutor() {
        if (executorService != null) return executorService;
        Class<InetUtils> clazz = InetUtils.class;
        synchronized (InetUtils.class) {
            if (executorService != null) return executorService;
            executorService = Executors.newSingleThreadExecutor(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread thread = new Thread(r);
                    thread.setName("spring.cloud.inetutils");
                    thread.setDaemon(true);
                    return thread;
                }
            });
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return executorService;
        }
    }

    public HostInfo findFirstNonLoopbackHostInfo() {
        InetAddress address = this.findFirstNonLoopbackAddress();
        if (address != null) {
            return this.convertAddress(address);
        }
        HostInfo hostInfo = new HostInfo();
        hostInfo.setHostname(this.properties.getDefaultHostname());
        hostInfo.setIpAddress(this.properties.getDefaultIpAddress());
        return hostInfo;
    }

    public InetAddress findFirstNonLoopbackAddress() {
        InetAddress result = null;
        try {
            int lowest = Integer.MAX_VALUE;
            Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
            while (nics.hasMoreElements()) {
                NetworkInterface ifc = nics.nextElement();
                if (!ifc.isUp()) continue;
                log.trace((Object)("Testing interface: " + ifc.getDisplayName()));
                if (ifc.getIndex() < lowest || result == null) {
                    lowest = ifc.getIndex();
                } else if (result != null) continue;
                if (this.ignoreInterface(ifc.getDisplayName())) continue;
                Enumeration<InetAddress> addrs = ifc.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress address = addrs.nextElement();
                    if (!(address instanceof Inet4Address) || address.isLoopbackAddress()) continue;
                    log.trace((Object)("Found non-loopback interface: " + ifc.getDisplayName()));
                    result = address;
                }
            }
        }
        catch (IOException ex) {
            log.error((Object)"Cannot get first non-loopback address", (Throwable)ex);
        }
        if (result != null) {
            return result;
        }
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            log.warn((Object)"Unable to retrieve localhost");
            return null;
        }
    }

    boolean ignoreInterface(String interfaceName) {
        for (String regex : this.properties.getIgnoredInterfaces()) {
            if (!interfaceName.matches(regex)) continue;
            log.trace((Object)("Ignoring interface: " + interfaceName));
            return true;
        }
        return false;
    }

    public HostInfo convertAddress(final InetAddress address) {
        String hostname;
        HostInfo hostInfo = new HostInfo();
        Future<String> result = this.getExecutor().submit(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return address.getHostName();
            }
        });
        try {
            hostname = result.get(this.properties.getTimeoutSeconds(), TimeUnit.SECONDS);
        }
        catch (Exception e) {
            log.info((Object)"Cannot determine local hostname");
            hostname = "localhost";
        }
        hostInfo.setHostname(hostname);
        hostInfo.setIpAddress(address.getHostAddress());
        return hostInfo;
    }

    @Deprecated
    public static HostInfo getFirstNonLoopbackHostInfo() {
        return instance.findFirstNonLoopbackHostInfo();
    }

    @Deprecated
    public static HostInfo convert(InetAddress address) {
        return instance.convertAddress(address);
    }

    public static int getIpAddressAsInt(String host) {
        return new HostInfo(host).getIpAddressAsInt();
    }

    static {
        instance = new InetUtils(new InetUtilsProperties());
    }

    public static final class HostInfo {
        public boolean override;
        private String ipAddress;
        private String hostname;

        HostInfo(String hostname) {
            this.hostname = hostname;
        }

        HostInfo() {
        }

        public int getIpAddressAsInt() {
            InetAddress inetAddress = null;
            String host = this.ipAddress;
            if (host == null) {
                host = this.hostname;
            }
            try {
                inetAddress = InetAddress.getByName(host);
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException(e);
            }
            return ByteBuffer.wrap(inetAddress.getAddress()).getInt();
        }

        public boolean isOverride() {
            return this.override;
        }

        public String getIpAddress() {
            return this.ipAddress;
        }

        public String getHostname() {
            return this.hostname;
        }

        public void setOverride(boolean override) {
            this.override = override;
        }

        public void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public void setHostname(String hostname) {
            this.hostname = hostname;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HostInfo)) {
                return false;
            }
            HostInfo other = (HostInfo)o;
            if (this.isOverride() != other.isOverride()) {
                return false;
            }
            String this$ipAddress = this.getIpAddress();
            String other$ipAddress = other.getIpAddress();
            if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) {
                return false;
            }
            String this$hostname = this.getHostname();
            String other$hostname = other.getHostname();
            return !(this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isOverride() ? 79 : 97);
            String $ipAddress = this.getIpAddress();
            result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
            String $hostname = this.getHostname();
            result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
            return result;
        }

        public String toString() {
            return "InetUtils.HostInfo(override=" + this.isOverride() + ", ipAddress=" + this.getIpAddress() + ", hostname=" + this.getHostname() + ")";
        }
    }
}

