/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.hypermedia;

import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.hypermedia.RemoteResource;
import org.springframework.cloud.client.hypermedia.RemoteResourceRefresher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnBean(type={"org.springframework.cloud.client.hypermedia.RemoteResource"})
@EnableConfigurationProperties(value={CloudHypermediaProperties.class})
public class CloudHypermediaAutoConfiguration {
    @Autowired(required=false)
    List<RemoteResource> discoveredResources = Collections.emptyList();
    @Autowired
    CloudHypermediaProperties properties;

    @Bean
    @ConditionalOnMissingBean
    public RemoteResourceRefresher discoveredResourceRefresher() {
        return new RemoteResourceRefresher(this.discoveredResources, this.properties.getRefresh().getFixedDelay(), this.properties.getRefresh().getInitialDelay());
    }

    @ConfigurationProperties(prefix="spring.cloud.hypermedia")
    public static class CloudHypermediaProperties {
        private Refresh refresh = new Refresh();

        public Refresh getRefresh() {
            return this.refresh;
        }

        public void setRefresh(Refresh refresh) {
            this.refresh = refresh;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CloudHypermediaProperties)) {
                return false;
            }
            CloudHypermediaProperties other = (CloudHypermediaProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Refresh this$refresh = this.getRefresh();
            Refresh other$refresh = other.getRefresh();
            return !(this$refresh == null ? other$refresh != null : !((Object)this$refresh).equals(other$refresh));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CloudHypermediaProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Refresh $refresh = this.getRefresh();
            result = result * 59 + ($refresh == null ? 43 : ((Object)$refresh).hashCode());
            return result;
        }

        public String toString() {
            return "CloudHypermediaAutoConfiguration.CloudHypermediaProperties(refresh=" + this.getRefresh() + ")";
        }

        public static class Refresh {
            private int fixedDelay = 5000;
            private int initialDelay = 10000;

            public int getFixedDelay() {
                return this.fixedDelay;
            }

            public int getInitialDelay() {
                return this.initialDelay;
            }

            public void setFixedDelay(int fixedDelay) {
                this.fixedDelay = fixedDelay;
            }

            public void setInitialDelay(int initialDelay) {
                this.initialDelay = initialDelay;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Refresh)) {
                    return false;
                }
                Refresh other = (Refresh)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.getFixedDelay() != other.getFixedDelay()) {
                    return false;
                }
                return this.getInitialDelay() == other.getInitialDelay();
            }

            protected boolean canEqual(Object other) {
                return other instanceof Refresh;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + this.getFixedDelay();
                result = result * 59 + this.getInitialDelay();
                return result;
            }

            public String toString() {
                return "CloudHypermediaAutoConfiguration.CloudHypermediaProperties.Refresh(fixedDelay=" + this.getFixedDelay() + ", initialDelay=" + this.getInitialDelay() + ")";
            }
        }
    }
}

