/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bus.event;

import org.springframework.cloud.bus.event.RemoteApplicationEvent;
import org.springframework.core.style.ToStringCreator;

public class UnknownRemoteApplicationEvent
extends RemoteApplicationEvent {
    protected String typeInfo;
    protected byte[] payload;

    private UnknownRemoteApplicationEvent() {
        this.typeInfo = null;
        this.payload = null;
    }

    public UnknownRemoteApplicationEvent(Object source, String typeInfo, byte[] payload) {
        super(source, "", () -> "unknown");
        this.typeInfo = typeInfo;
        this.payload = payload;
    }

    public String getTypeInfo() {
        return this.typeInfo;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public String getPayloadAsString() {
        if (this.payload != null) {
            return new String(this.payload);
        }
        return null;
    }

    @Override
    public String toString() {
        return new ToStringCreator((Object)this).append("id", (Object)this.getId()).append("originService", (Object)this.getOriginService()).append("destinationService", (Object)this.getDestinationService()).append("typeInfo", (Object)this.typeInfo).append("payload", (Object)this.getPayloadAsString()).toString();
    }
}

