/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bus.event;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.springframework.cloud.bus.event.RemoteApplicationEvent;
import org.springframework.context.ApplicationEvent;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonIgnoreProperties(value={"source"})
public class SentApplicationEvent
extends ApplicationEvent {
    private static final Object TRANSIENT_SOURCE = new Object();
    private final String originService;
    private final String destinationService;
    private final String id;
    private Class<? extends RemoteApplicationEvent> type;

    protected SentApplicationEvent() {
        this(TRANSIENT_SOURCE, null, null, null, RemoteApplicationEvent.class);
    }

    public SentApplicationEvent(Object source, String originService, String destinationService, String id, Class<? extends RemoteApplicationEvent> type) {
        super(source);
        this.originService = originService;
        this.type = type;
        if (destinationService == null) {
            destinationService = "*";
        }
        if (!destinationService.contains(":")) {
            destinationService = destinationService + ":**";
        }
        this.destinationService = destinationService;
        this.id = id;
    }

    public Class<? extends RemoteApplicationEvent> getType() {
        return this.type;
    }

    public void setType(Class<? extends RemoteApplicationEvent> type) {
        this.type = type;
    }

    public String getOriginService() {
        return this.originService;
    }

    public String getDestinationService() {
        return this.destinationService;
    }

    public String getId() {
        return this.id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.destinationService == null ? 0 : this.destinationService.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.originService == null ? 0 : this.originService.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        SentApplicationEvent other = (SentApplicationEvent)((Object)obj);
        if (this.destinationService == null ? other.destinationService != null : !this.destinationService.equals(other.destinationService)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.originService == null ? other.originService != null : !this.originService.equals(other.originService)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

