/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.servlet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.TypeReference;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotContribution;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotProcessor;
import org.springframework.beans.factory.aot.BeanFactoryInitializationCode;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.web.servlet.ServletComponentHandler;
import org.springframework.boot.web.servlet.WebFilterHandler;
import org.springframework.boot.web.servlet.WebListenerHandler;
import org.springframework.boot.web.servlet.WebServletHandler;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.io.ResourceLoader;
import org.springframework.mock.web.MockServletContext;
import org.springframework.util.ClassUtils;
import org.springframework.web.context.WebApplicationContext;

class ServletComponentRegisteringPostProcessor
implements BeanFactoryPostProcessor,
ApplicationContextAware,
BeanFactoryInitializationAotProcessor {
    private static final boolean MOCK_SERVLET_CONTEXT_AVAILABLE = ClassUtils.isPresent((String)"org.springframework.mock.web.MockServletContext", null);
    private static final List<ServletComponentHandler> HANDLERS;
    private final Set<String> packagesToScan;
    private ApplicationContext applicationContext;

    ServletComponentRegisteringPostProcessor(Set<String> packagesToScan) {
        this.packagesToScan = packagesToScan;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (this.eligibleForServletComponentScanning()) {
            ClassPathScanningCandidateComponentProvider componentProvider = this.createComponentProvider();
            for (String packageToScan : this.packagesToScan) {
                this.scanPackage(componentProvider, packageToScan);
            }
        }
    }

    private void scanPackage(ClassPathScanningCandidateComponentProvider componentProvider, String packageToScan) {
        for (BeanDefinition candidate : componentProvider.findCandidateComponents(packageToScan)) {
            if (!(candidate instanceof AnnotatedBeanDefinition)) continue;
            AnnotatedBeanDefinition annotatedBeanDefinition = (AnnotatedBeanDefinition)candidate;
            for (ServletComponentHandler handler : HANDLERS) {
                handler.handle(annotatedBeanDefinition, (BeanDefinitionRegistry)this.applicationContext);
            }
        }
    }

    private boolean eligibleForServletComponentScanning() {
        WebApplicationContext webApplicationContext;
        ApplicationContext applicationContext = this.applicationContext;
        return applicationContext instanceof WebApplicationContext && ((webApplicationContext = (WebApplicationContext)applicationContext).getServletContext() == null || MOCK_SERVLET_CONTEXT_AVAILABLE && webApplicationContext.getServletContext() instanceof MockServletContext);
    }

    private ClassPathScanningCandidateComponentProvider createComponentProvider() {
        ClassPathScanningCandidateComponentProvider componentProvider = new ClassPathScanningCandidateComponentProvider(false);
        componentProvider.setEnvironment(this.applicationContext.getEnvironment());
        componentProvider.setResourceLoader((ResourceLoader)this.applicationContext);
        for (ServletComponentHandler handler : HANDLERS) {
            componentProvider.addIncludeFilter(handler.getTypeFilter());
        }
        return componentProvider;
    }

    Set<String> getPackagesToScan() {
        return Collections.unmodifiableSet(this.packagesToScan);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public BeanFactoryInitializationAotContribution processAheadOfTime(final ConfigurableListableBeanFactory beanFactory) {
        return new BeanFactoryInitializationAotContribution(){

            public void applyTo(GenerationContext generationContext, BeanFactoryInitializationCode beanFactoryInitializationCode) {
                for (String beanName : beanFactory.getBeanDefinitionNames()) {
                    BeanDefinition definition = beanFactory.getBeanDefinition(beanName);
                    if (!Objects.equals(definition.getBeanClassName(), WebListenerHandler.ServletComponentWebListenerRegistrar.class.getName())) continue;
                    String listenerClassName = (String)definition.getConstructorArgumentValues().getArgumentValue(0, String.class).getValue();
                    generationContext.getRuntimeHints().reflection().registerType(TypeReference.of((String)listenerClassName), new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS});
                }
            }
        };
    }

    static {
        ArrayList<ServletComponentHandler> servletComponentHandlers = new ArrayList<ServletComponentHandler>();
        servletComponentHandlers.add(new WebServletHandler());
        servletComponentHandlers.add(new WebFilterHandler());
        servletComponentHandlers.add(new WebListenerHandler());
        HANDLERS = Collections.unmodifiableList(servletComponentHandlers);
    }
}

