/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context;

import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.boot.context.annotation.DeterminableImports;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotatedBeanDefinitionReader;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.annotation.AnnotationFilter;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.annotation.Order;
import org.springframework.core.style.ToStringCreator;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.util.ReflectionUtils;

class ImportsContextCustomizer
implements ContextCustomizer {
    private static final String TEST_CLASS_NAME_ATTRIBUTE = "testClassName";
    private final String testClassName;
    private final ContextCustomizerKey key;

    ImportsContextCustomizer(Class<?> testClass) {
        this.testClassName = testClass.getName();
        this.key = new ContextCustomizerKey(testClass);
    }

    public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedContextConfiguration) {
        BeanDefinitionRegistry registry = this.getBeanDefinitionRegistry((ApplicationContext)context);
        AnnotatedBeanDefinitionReader reader = new AnnotatedBeanDefinitionReader(registry);
        this.registerCleanupPostProcessor(registry, reader);
        this.registerImportsConfiguration(registry, reader);
    }

    private void registerCleanupPostProcessor(BeanDefinitionRegistry registry, AnnotatedBeanDefinitionReader reader) {
        BeanDefinition definition = this.registerBean(registry, reader, ImportsCleanupPostProcessor.BEAN_NAME, ImportsCleanupPostProcessor.class);
        definition.setRole(2);
        definition.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)this.testClassName);
    }

    private void registerImportsConfiguration(BeanDefinitionRegistry registry, AnnotatedBeanDefinitionReader reader) {
        BeanDefinition definition = this.registerBean(registry, reader, ImportsConfiguration.BEAN_NAME, ImportsConfiguration.class);
        definition.setAttribute(TEST_CLASS_NAME_ATTRIBUTE, (Object)this.testClassName);
    }

    private BeanDefinitionRegistry getBeanDefinitionRegistry(ApplicationContext context) {
        if (context instanceof BeanDefinitionRegistry) {
            BeanDefinitionRegistry beanDefinitionRegistry = (BeanDefinitionRegistry)context;
            return beanDefinitionRegistry;
        }
        if (context instanceof AbstractApplicationContext) {
            AbstractApplicationContext abstractContext = (AbstractApplicationContext)context;
            return (BeanDefinitionRegistry)abstractContext.getBeanFactory();
        }
        throw new IllegalStateException("Could not locate BeanDefinitionRegistry");
    }

    private BeanDefinition registerBean(BeanDefinitionRegistry registry, AnnotatedBeanDefinitionReader reader, String beanName, Class<?> type) {
        reader.registerBean(type, beanName);
        return registry.getBeanDefinition(beanName);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ImportsContextCustomizer other = (ImportsContextCustomizer)obj;
        return this.key.equals(other.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("key", (Object)this.key).toString();
    }

    static class ContextCustomizerKey {
        private static final Set<AnnotationFilter> ANNOTATION_FILTERS;
        private final Set<Object> key;

        ContextCustomizerKey(Class<?> testClass) {
            MergedAnnotations annotations = MergedAnnotations.search((MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).withAnnotationFilter(this::isFilteredAnnotation).from(testClass);
            Set<Object> determinedImports = this.determineImports(annotations, testClass);
            if (determinedImports == null) {
                this.key = Collections.unmodifiableSet(this.synthesize(annotations));
            } else {
                HashSet<Object> key = new HashSet<Object>(determinedImports);
                Set componentScanning = annotations.stream().filter(annotation -> annotation.getType().equals(ComponentScan.class)).map(MergedAnnotation::synthesize).collect(Collectors.toSet());
                key.addAll(componentScanning);
                this.key = Collections.unmodifiableSet(key);
            }
        }

        private boolean isFilteredAnnotation(String typeName) {
            return ANNOTATION_FILTERS.stream().anyMatch(filter -> filter.matches(typeName));
        }

        private Set<Object> determineImports(MergedAnnotations annotations, Class<?> testClass) {
            LinkedHashSet<Object> determinedImports = new LinkedHashSet<Object>();
            AnnotationMetadata metadata = AnnotationMetadata.introspect(testClass);
            for (MergedAnnotation annotation : annotations.stream(Import.class).toList()) {
                for (Class source : annotation.getClassArray("value")) {
                    Set<Object> determinedSourceImports = this.determineImports(source, metadata);
                    if (determinedSourceImports == null) {
                        return null;
                    }
                    determinedImports.addAll(determinedSourceImports);
                }
            }
            return determinedImports;
        }

        private Set<Object> determineImports(Class<?> source, AnnotationMetadata metadata) {
            if (DeterminableImports.class.isAssignableFrom(source)) {
                return ((DeterminableImports)this.instantiate(source)).determineImports(metadata);
            }
            if (ImportSelector.class.isAssignableFrom(source) || ImportBeanDefinitionRegistrar.class.isAssignableFrom(source)) {
                return null;
            }
            return Collections.singleton(source.getName());
        }

        private Set<Object> synthesize(MergedAnnotations annotations) {
            return annotations.stream().map(MergedAnnotation::synthesize).collect(Collectors.toSet());
        }

        private <T> T instantiate(Class<T> source) {
            try {
                Constructor<T> constructor = source.getDeclaredConstructor(new Class[0]);
                ReflectionUtils.makeAccessible(constructor);
                return constructor.newInstance(new Object[0]);
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Unable to instantiate DeterminableImportSelector " + source.getName(), ex);
            }
        }

        public boolean equals(Object obj) {
            return obj != null && this.getClass() == obj.getClass() && this.key.equals(((ContextCustomizerKey)obj).key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public String toString() {
            return this.key.toString();
        }

        static {
            LinkedHashSet<AnnotationFilter> annotationFilters = new LinkedHashSet<AnnotationFilter>();
            annotationFilters.add(AnnotationFilter.PLAIN);
            annotationFilters.add("kotlin.Metadata"::equals);
            annotationFilters.add(AnnotationFilter.packages((String[])new String[]{"kotlin.annotation"}));
            annotationFilters.add(AnnotationFilter.packages((String[])new String[]{"org.spockframework", "spock"}));
            annotationFilters.add(AnnotationFilter.packages((String[])new String[]{"org.junit"}));
            ANNOTATION_FILTERS = Collections.unmodifiableSet(annotationFilters);
        }
    }

    @Order(value=0x7FFFFFFF)
    static class ImportsCleanupPostProcessor
    implements BeanDefinitionRegistryPostProcessor {
        static final String BEAN_NAME = ImportsCleanupPostProcessor.class.getName();
        private final String testClassName;

        ImportsCleanupPostProcessor(String testClassName) {
            this.testClassName = testClassName;
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        }

        public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
            try {
                String[] names;
                for (String name : names = registry.getBeanDefinitionNames()) {
                    BeanDefinition definition = registry.getBeanDefinition(name);
                    if (!this.testClassName.equals(definition.getBeanClassName())) continue;
                    registry.removeBeanDefinition(name);
                }
                registry.removeBeanDefinition(ImportsConfiguration.BEAN_NAME);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Import(value={ImportsSelector.class})
    static class ImportsConfiguration {
        static final String BEAN_NAME = ImportsConfiguration.class.getName();

        ImportsConfiguration() {
        }
    }

    static class ImportsSelector
    implements ImportSelector,
    BeanFactoryAware {
        private static final String[] NO_IMPORTS = new String[0];
        private ConfigurableListableBeanFactory beanFactory;

        ImportsSelector() {
        }

        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
        }

        public String[] selectImports(AnnotationMetadata importingClassMetadata) {
            String[] stringArray;
            BeanDefinition definition = this.beanFactory.getBeanDefinition(ImportsConfiguration.BEAN_NAME);
            Object testClassName = definition.getAttribute(ImportsContextCustomizer.TEST_CLASS_NAME_ATTRIBUTE);
            if (testClassName != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = (String)testClassName;
            } else {
                stringArray = NO_IMPORTS;
            }
            return stringArray;
        }
    }
}

