/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import java.util.Arrays;
import java.util.HashSet;
import org.mockito.Mockito;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.test.mock.mockito.MockReset;
import org.springframework.boot.test.mock.mockito.MockitoBeans;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;

public class ResetMocksTestExecutionListener
extends AbstractTestExecutionListener {
    public void beforeTestMethod(TestContext testContext) throws Exception {
        this.resetMocks(testContext.getApplicationContext(), MockReset.BEFORE);
    }

    public void afterTestMethod(TestContext testContext) throws Exception {
        this.resetMocks(testContext.getApplicationContext(), MockReset.AFTER);
    }

    private void resetMocks(ApplicationContext applicationContext, MockReset reset) {
        if (applicationContext instanceof ConfigurableApplicationContext) {
            this.resetMocks((ConfigurableApplicationContext)applicationContext, reset);
        }
    }

    private void resetMocks(ConfigurableApplicationContext applicationContext, MockReset reset) {
        ConfigurableListableBeanFactory beanFactory = applicationContext.getBeanFactory();
        String[] names = beanFactory.getBeanDefinitionNames();
        HashSet<String> instantiatedSingletons = new HashSet<String>(Arrays.asList(beanFactory.getSingletonNames()));
        for (String name : names) {
            Object bean;
            BeanDefinition definition = beanFactory.getBeanDefinition(name);
            if (!definition.isSingleton() || !instantiatedSingletons.contains(name) || !reset.equals((Object)MockReset.get(bean = beanFactory.getSingleton(name)))) continue;
            Mockito.reset((Object[])new Object[]{bean});
        }
        try {
            MockitoBeans mockedBeans = (MockitoBeans)beanFactory.getBean(MockitoBeans.class);
            for (Object mockedBean : mockedBeans) {
                if (!reset.equals((Object)MockReset.get(mockedBean))) continue;
                Mockito.reset((Object[])new Object[]{mockedBean});
            }
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        if (applicationContext.getParent() != null) {
            this.resetMocks(applicationContext.getParent(), reset);
        }
    }
}

