/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.properties;

import java.lang.annotation.Annotation;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.test.autoconfigure.properties.AnnotationsPropertySource;
import org.springframework.boot.test.autoconfigure.properties.PropertyMapping;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.PropertySource;
import org.springframework.stereotype.Component;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.util.ClassUtils;

class PropertyMappingContextCustomizer
implements ContextCustomizer {
    private final AnnotationsPropertySource propertySource;

    PropertyMappingContextCustomizer(AnnotationsPropertySource propertySource) {
        this.propertySource = propertySource;
    }

    public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedContextConfiguration) {
        if (!this.propertySource.isEmpty()) {
            context.getEnvironment().getPropertySources().addFirst((PropertySource)this.propertySource);
        }
        context.getBeanFactory().registerSingleton(PropertyMappingCheckBeanPostProcessor.class.getName(), (Object)new PropertyMappingCheckBeanPostProcessor());
    }

    public int hashCode() {
        return this.propertySource.hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass().equals(obj.getClass()) && this.propertySource.equals((Object)((PropertyMappingContextCustomizer)obj).propertySource);
    }

    static class PropertyMappingCheckBeanPostProcessor
    implements BeanPostProcessor {
        PropertyMappingCheckBeanPostProcessor() {
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            LinkedHashSet components = new LinkedHashSet();
            LinkedHashSet propertyMappings = new LinkedHashSet();
            for (Class<?> beanClass = bean.getClass(); beanClass != null; beanClass = beanClass.getSuperclass()) {
                for (Annotation annotation : AnnotationUtils.getAnnotations(beanClass)) {
                    if (this.isAnnotated(annotation, Component.class)) {
                        components.add(annotation.annotationType());
                    }
                    if (!this.isAnnotated(annotation, PropertyMapping.class)) continue;
                    propertyMappings.add(annotation.annotationType());
                }
            }
            if (!components.isEmpty() && !propertyMappings.isEmpty()) {
                throw new IllegalStateException("The @PropertyMapping " + this.getAnnotationsDescription(propertyMappings) + " cannot be used in combination with the @Component " + this.getAnnotationsDescription(components));
            }
            return bean;
        }

        private boolean isAnnotated(Annotation element, Class<? extends Annotation> annotationType) {
            try {
                return element.annotationType().equals(annotationType) || AnnotationUtils.findAnnotation(element.annotationType(), annotationType) != null;
            }
            catch (Throwable ex) {
                return false;
            }
        }

        private String getAnnotationsDescription(Set<Class<?>> annotations) {
            StringBuilder result = new StringBuilder();
            for (Class<?> annotation : annotations) {
                result.append(result.length() == 0 ? "" : ", ");
                result.append("@" + ClassUtils.getShortName(annotation));
            }
            result.insert(0, annotations.size() == 1 ? "annotation " : "annotations ");
            return result.toString();
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            return bean;
        }
    }
}

