/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.maven.artifact.Artifact;
import org.springframework.boot.maven.DependencyFilter;

class JarTypeFilter
extends DependencyFilter {
    private static final Set<String> EXCLUDED_JAR_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("annotation-processor", "dependencies-starter")));

    JarTypeFilter() {
        super(Collections.emptyList());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean filter(Artifact artifact) {
        try (JarFile jarFile = new JarFile(artifact.getFile());){
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) return false;
            String jarType = manifest.getMainAttributes().getValue("Spring-Boot-Jar-Type");
            if (jarType == null) return false;
            if (!EXCLUDED_JAR_TYPES.contains(jarType)) return false;
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }
}

