/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.tools;

import java.io.File;
import java.io.IOException;
import java.nio.file.attribute.FileTime;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarFile;
import org.springframework.boot.loader.tools.AbstractJarWriter;
import org.springframework.boot.loader.tools.FileUtils;
import org.springframework.boot.loader.tools.JarModeLibrary;
import org.springframework.boot.loader.tools.JarWriter;
import org.springframework.boot.loader.tools.LaunchScript;
import org.springframework.boot.loader.tools.Libraries;
import org.springframework.boot.loader.tools.Library;
import org.springframework.boot.loader.tools.Packager;
import org.springframework.util.Assert;

public class Repackager
extends Packager {
    private boolean backupSource = true;

    public Repackager(File source) {
        super(source);
    }

    @Override
    protected void writeSignatureFileIfNecessary(Map<String, Library> writtenLibraries, AbstractJarWriter writer) throws IOException {
        if (this.getSource().getName().toLowerCase(Locale.ROOT).endsWith(".jar") && this.hasSignedLibrary(writtenLibraries)) {
            writer.writeEntry("META-INF/BOOT.SF", entryWriter -> {});
        }
    }

    private boolean hasSignedLibrary(Map<String, Library> writtenLibraries) throws IOException {
        for (Library library : writtenLibraries.values()) {
            if (library instanceof JarModeLibrary || !FileUtils.isSignedJarFile(library.getFile())) continue;
            return true;
        }
        return false;
    }

    public void setBackupSource(boolean backupSource) {
        this.backupSource = backupSource;
    }

    public void repackage(Libraries libraries) throws IOException {
        this.repackage(this.getSource(), libraries);
    }

    public void repackage(File destination, Libraries libraries) throws IOException {
        this.repackage(destination, libraries, null);
    }

    public void repackage(File destination, Libraries libraries, LaunchScript launchScript) throws IOException {
        this.repackage(destination, libraries, launchScript, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repackage(File destination, Libraries libraries, LaunchScript launchScript, FileTime lastModifiedTime) throws IOException {
        Assert.isTrue((destination != null && !destination.isDirectory() ? 1 : 0) != 0, (String)"Invalid destination");
        this.getLayout();
        destination = destination.getAbsoluteFile();
        File source = this.getSource();
        if (this.isAlreadyPackaged() && source.equals(destination)) {
            return;
        }
        File workingSource = source;
        if (source.equals(destination)) {
            workingSource = this.getBackupFile();
            workingSource.delete();
            this.renameFile(source, workingSource);
        }
        destination.delete();
        try (JarFile sourceJar = new JarFile(workingSource);){
            this.repackage(sourceJar, destination, libraries, launchScript, lastModifiedTime);
        }
        finally {
            if (!this.backupSource && !source.equals(workingSource)) {
                this.deleteFile(workingSource);
            }
        }
    }

    private void repackage(JarFile sourceJar, File destination, Libraries libraries, LaunchScript launchScript, FileTime lastModifiedTime) throws IOException {
        try (JarWriter writer = new JarWriter(destination, launchScript, lastModifiedTime);){
            this.write(sourceJar, libraries, writer, lastModifiedTime != null);
        }
        if (lastModifiedTime != null) {
            destination.setLastModified(lastModifiedTime.toMillis());
        }
    }

    private void renameFile(File file, File dest) {
        if (!file.renameTo(dest)) {
            throw new IllegalStateException("Unable to rename '" + String.valueOf(file) + "' to '" + String.valueOf(dest) + "'");
        }
    }

    private void deleteFile(File file) {
        if (!file.delete()) {
            throw new IllegalStateException("Unable to delete '" + String.valueOf(file) + "'");
        }
    }
}

