/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.configurationprocessor.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.boot.configurationprocessor.metadata.ConfigurationMetadata;
import org.springframework.boot.configurationprocessor.metadata.ItemDeprecation;
import org.springframework.boot.configurationprocessor.metadata.ItemHint;
import org.springframework.boot.configurationprocessor.metadata.ItemMetadata;

public class JsonMarshaller {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final int BUFFER_SIZE = 4098;

    public void write(ConfigurationMetadata metadata, OutputStream outputStream) throws IOException {
        JSONOrderedObject object = new JSONOrderedObject();
        object.put("groups", this.toJsonArray(metadata, ItemMetadata.ItemType.GROUP));
        object.put("properties", this.toJsonArray(metadata, ItemMetadata.ItemType.PROPERTY));
        object.put("hints", this.toJsonArray(metadata.getHints()));
        outputStream.write(object.toString(2).getBytes(UTF_8));
    }

    private JSONArray toJsonArray(ConfigurationMetadata metadata, ItemMetadata.ItemType itemType) {
        JSONArray jsonArray = new JSONArray();
        for (ItemMetadata item : metadata.getItems()) {
            if (!item.isOfItemType(itemType)) continue;
            jsonArray.put((Object)this.toJsonObject(item));
        }
        return jsonArray;
    }

    private JSONArray toJsonArray(Collection<ItemHint> hints) {
        JSONArray jsonArray = new JSONArray();
        for (ItemHint hint : hints) {
            jsonArray.put((Object)this.toJsonObject(hint));
        }
        return jsonArray;
    }

    private JSONObject toJsonObject(ItemMetadata item) {
        ItemDeprecation deprecation;
        JSONOrderedObject jsonObject = new JSONOrderedObject();
        jsonObject.put("name", item.getName());
        this.putIfPresent(jsonObject, "type", item.getType());
        this.putIfPresent(jsonObject, "description", item.getDescription());
        this.putIfPresent(jsonObject, "sourceType", item.getSourceType());
        this.putIfPresent(jsonObject, "sourceMethod", item.getSourceMethod());
        Object defaultValue = item.getDefaultValue();
        if (defaultValue != null) {
            this.putDefaultValue(jsonObject, defaultValue);
        }
        if ((deprecation = item.getDeprecation()) != null) {
            jsonObject.put("deprecated", true);
            JSONObject deprecationJsonObject = new JSONObject();
            if (deprecation.getReason() != null) {
                deprecationJsonObject.put("reason", (Object)deprecation.getReason());
            }
            if (deprecation.getReplacement() != null) {
                deprecationJsonObject.put("replacement", (Object)deprecation.getReplacement());
            }
            jsonObject.put("deprecation", deprecationJsonObject);
        }
        return jsonObject;
    }

    private JSONObject toJsonObject(ItemHint hint) {
        JSONOrderedObject jsonObject = new JSONOrderedObject();
        jsonObject.put("name", hint.getName());
        if (!hint.getValues().isEmpty()) {
            jsonObject.put("values", this.getItemHintValues(hint));
        }
        if (!hint.getProviders().isEmpty()) {
            jsonObject.put("providers", this.getItemHintProviders(hint));
        }
        return jsonObject;
    }

    private JSONArray getItemHintValues(ItemHint hint) {
        JSONArray values = new JSONArray();
        for (ItemHint.ValueHint value : hint.getValues()) {
            values.put((Object)this.getItemHintValue(value));
        }
        return values;
    }

    private JSONObject getItemHintValue(ItemHint.ValueHint value) {
        JSONOrderedObject result = new JSONOrderedObject();
        this.putHintValue(result, value.getValue());
        this.putIfPresent(result, "description", value.getDescription());
        return result;
    }

    private JSONArray getItemHintProviders(ItemHint hint) {
        JSONArray providers = new JSONArray();
        for (ItemHint.ValueProvider provider : hint.getProviders()) {
            providers.put((Object)this.getItemHintProvider(provider));
        }
        return providers;
    }

    private JSONObject getItemHintProvider(ItemHint.ValueProvider provider) {
        JSONOrderedObject result = new JSONOrderedObject();
        result.put("name", provider.getName());
        if (provider.getParameters() != null && !provider.getParameters().isEmpty()) {
            JSONOrderedObject parameters = new JSONOrderedObject();
            for (Map.Entry<String, Object> entry : provider.getParameters().entrySet()) {
                parameters.put(entry.getKey(), this.extractItemValue(entry.getValue()));
            }
            result.put("parameters", (Object)parameters);
        }
        return result;
    }

    private void putIfPresent(JSONObject jsonObject, String name, Object value) {
        if (value != null) {
            jsonObject.put(name, value);
        }
    }

    private void putHintValue(JSONObject jsonObject, Object value) {
        Object hintValue = this.extractItemValue(value);
        jsonObject.put("value", hintValue);
    }

    private void putDefaultValue(JSONObject jsonObject, Object value) {
        Object defaultValue = this.extractItemValue(value);
        jsonObject.put("defaultValue", defaultValue);
    }

    private Object extractItemValue(Object value) {
        Object defaultValue = value;
        if (value.getClass().isArray()) {
            JSONArray array = new JSONArray();
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                array.put(Array.get(value, i));
            }
            defaultValue = array;
        }
        return defaultValue;
    }

    public ConfigurationMetadata read(InputStream inputStream) throws IOException {
        JSONArray hints;
        JSONArray properties;
        ConfigurationMetadata metadata = new ConfigurationMetadata();
        JSONObject object = new JSONObject(this.toString(inputStream));
        JSONArray groups = object.optJSONArray("groups");
        if (groups != null) {
            for (int i = 0; i < groups.length(); ++i) {
                metadata.add(this.toItemMetadata((JSONObject)groups.get(i), ItemMetadata.ItemType.GROUP));
            }
        }
        if ((properties = object.optJSONArray("properties")) != null) {
            for (int i = 0; i < properties.length(); ++i) {
                metadata.add(this.toItemMetadata((JSONObject)properties.get(i), ItemMetadata.ItemType.PROPERTY));
            }
        }
        if ((hints = object.optJSONArray("hints")) != null) {
            for (int i = 0; i < hints.length(); ++i) {
                metadata.add(this.toItemHint((JSONObject)hints.get(i)));
            }
        }
        return metadata;
    }

    private ItemMetadata toItemMetadata(JSONObject object, ItemMetadata.ItemType itemType) {
        String name = object.getString("name");
        String type = object.optString("type", null);
        String description = object.optString("description", null);
        String sourceType = object.optString("sourceType", null);
        String sourceMethod = object.optString("sourceMethod", null);
        Object defaultValue = this.readItemValue(object.opt("defaultValue"));
        ItemDeprecation deprecation = this.toItemDeprecation(object);
        return new ItemMetadata(itemType, name, null, type, sourceType, sourceMethod, description, defaultValue, deprecation);
    }

    private ItemDeprecation toItemDeprecation(JSONObject object) {
        if (object.has("deprecation")) {
            JSONObject deprecationJsonObject = object.getJSONObject("deprecation");
            ItemDeprecation deprecation = new ItemDeprecation();
            deprecation.setReason(deprecationJsonObject.optString("reason", null));
            deprecation.setReplacement(deprecationJsonObject.optString("replacement", null));
            return deprecation;
        }
        return object.optBoolean("deprecated") ? new ItemDeprecation() : null;
    }

    private ItemHint toItemHint(JSONObject object) {
        String name = object.getString("name");
        ArrayList<ItemHint.ValueHint> values = new ArrayList<ItemHint.ValueHint>();
        if (object.has("values")) {
            JSONArray valuesArray = object.getJSONArray("values");
            for (int i = 0; i < valuesArray.length(); ++i) {
                values.add(this.toValueHint((JSONObject)valuesArray.get(i)));
            }
        }
        ArrayList<ItemHint.ValueProvider> providers = new ArrayList<ItemHint.ValueProvider>();
        if (object.has("providers")) {
            JSONArray providersObject = object.getJSONArray("providers");
            for (int i = 0; i < providersObject.length(); ++i) {
                providers.add(this.toValueProvider((JSONObject)providersObject.get(i)));
            }
        }
        return new ItemHint(name, values, providers);
    }

    private ItemHint.ValueHint toValueHint(JSONObject object) {
        Object value = this.readItemValue(object.get("value"));
        String description = object.optString("description", null);
        return new ItemHint.ValueHint(value, description);
    }

    private ItemHint.ValueProvider toValueProvider(JSONObject object) {
        String name = object.getString("name");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (object.has("parameters")) {
            JSONObject parametersObject = object.getJSONObject("parameters");
            for (Object k : parametersObject.keySet()) {
                String key = (String)k;
                Object value = this.readItemValue(parametersObject.get(key));
                parameters.put(key, value);
            }
        }
        return new ItemHint.ValueProvider(name, parameters);
    }

    private Object readItemValue(Object value) {
        if (value instanceof JSONArray) {
            JSONArray array = (JSONArray)value;
            Object[] content = new Object[array.length()];
            for (int i = 0; i < array.length(); ++i) {
                content[i] = array.get(i);
            }
            return content;
        }
        return value;
    }

    private String toString(InputStream inputStream) throws IOException {
        int bytesRead;
        StringBuilder out = new StringBuilder();
        InputStreamReader reader = new InputStreamReader(inputStream, UTF_8);
        char[] buffer = new char[4098];
        while ((bytesRead = reader.read(buffer)) != -1) {
            out.append(buffer, 0, bytesRead);
        }
        return out.toString();
    }

    private static class JSONOrderedObject
    extends JSONObject {
        private Set<String> keys = new LinkedHashSet<String>();

        private JSONOrderedObject() {
        }

        public JSONObject put(String key, Object value) throws JSONException {
            this.keys.add(key);
            return super.put(key, value);
        }

        public Set keySet() {
            return this.keys;
        }
    }
}

