/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker;

import com.fasterxml.jackson.annotation.JsonCreator;
import org.springframework.boot.buildpack.platform.docker.UpdateEvent;

public abstract class ProgressUpdateEvent
extends UpdateEvent {
    private final String status;
    private final ProgressDetail progressDetail;
    private final String progress;

    protected ProgressUpdateEvent(String status, ProgressDetail progressDetail, String progress) {
        this.status = status;
        this.progressDetail = ProgressDetail.isEmpty(progressDetail) ? null : progressDetail;
        this.progress = progress;
    }

    public String getStatus() {
        return this.status;
    }

    public ProgressDetail getProgressDetail() {
        return this.progressDetail;
    }

    public String getProgress() {
        return this.progress;
    }

    public static class ProgressDetail {
        private final Long current;
        private final Long total;

        @JsonCreator
        public ProgressDetail(Long current, Long total) {
            this.current = current;
            this.total = total;
        }

        @Deprecated(since="3.3.7", forRemoval=true)
        public int getCurrent() {
            return (int)Long.min(this.current, Integer.MAX_VALUE);
        }

        @Deprecated(since="3.3.7", forRemoval=true)
        public int getTotal() {
            return (int)Long.min(this.total, Integer.MAX_VALUE);
        }

        public int asPercentage() {
            int percentage = (int)(100.0 / (double)this.total.longValue() * (double)this.current.longValue());
            return percentage < 0 ? 0 : Math.min(percentage, 100);
        }

        @Deprecated(since="3.3.7", forRemoval=true)
        public static boolean isEmpty(ProgressDetail progressDetail) {
            return progressDetail == null || progressDetail.current == null || progressDetail.total == null;
        }
    }
}

