/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.build;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.springframework.boot.buildpack.platform.build.Buildpack;
import org.springframework.boot.buildpack.platform.build.BuildpackCoordinates;
import org.springframework.boot.buildpack.platform.build.BuildpackLayersMetadata;
import org.springframework.boot.buildpack.platform.build.BuildpackMetadata;
import org.springframework.boot.buildpack.platform.build.BuildpackReference;
import org.springframework.boot.buildpack.platform.build.BuildpackResolverContext;
import org.springframework.boot.buildpack.platform.build.ImageType;
import org.springframework.boot.buildpack.platform.docker.transport.DockerEngineException;
import org.springframework.boot.buildpack.platform.docker.type.Image;
import org.springframework.boot.buildpack.platform.docker.type.ImageReference;
import org.springframework.boot.buildpack.platform.docker.type.Layer;
import org.springframework.boot.buildpack.platform.docker.type.LayerId;
import org.springframework.boot.buildpack.platform.io.IOConsumer;
import org.springframework.boot.buildpack.platform.io.TarArchive;
import org.springframework.util.StreamUtils;

final class ImageBuildpack
implements Buildpack {
    private static final String PREFIX = "docker://";
    private final BuildpackCoordinates coordinates;
    private final ExportedLayers exportedLayers;

    private ImageBuildpack(BuildpackResolverContext context, ImageReference imageReference) {
        ImageReference reference = imageReference.inTaggedOrDigestForm();
        try {
            Image image = context.fetchImage(reference, ImageType.BUILDPACK);
            BuildpackMetadata buildpackMetadata = BuildpackMetadata.fromImage(image);
            this.coordinates = BuildpackCoordinates.fromBuildpackMetadata(buildpackMetadata);
            this.exportedLayers = !this.buildpackExistsInBuilder(context, image.getLayers()) ? new ExportedLayers(context, reference) : null;
        }
        catch (IOException | DockerEngineException ex) {
            throw new IllegalArgumentException("Error pulling buildpack image '" + reference + "'", ex);
        }
    }

    private boolean buildpackExistsInBuilder(BuildpackResolverContext context, List<LayerId> imageLayers) {
        BuildpackLayersMetadata.BuildpackLayerDetails buildpackLayerDetails = context.getBuildpackLayersMetadata().getBuildpack(this.coordinates.getId(), this.coordinates.getVersion());
        if (buildpackLayerDetails != null) {
            String layerDiffId = buildpackLayerDetails.getLayerDiffId();
            return imageLayers.stream().map(LayerId::toString).anyMatch(layerId -> layerId.equals(layerDiffId));
        }
        return false;
    }

    @Override
    public BuildpackCoordinates getCoordinates() {
        return this.coordinates;
    }

    @Override
    public void apply(IOConsumer<Layer> layers) throws IOException {
        if (this.exportedLayers != null) {
            this.exportedLayers.apply(layers);
        }
    }

    static Buildpack resolve(BuildpackResolverContext context, BuildpackReference reference) {
        boolean unambiguous = reference.hasPrefix(PREFIX);
        try {
            ImageReference imageReference = ImageReference.of(unambiguous ? reference.getSubReference(PREFIX) : reference.toString());
            return new ImageBuildpack(context, imageReference);
        }
        catch (IllegalArgumentException ex) {
            if (unambiguous) {
                throw ex;
            }
            return null;
        }
    }

    private static class ExportedLayers {
        private final List<Path> layerFiles;

        ExportedLayers(BuildpackResolverContext context, ImageReference imageReference) throws IOException {
            ArrayList layerFiles = new ArrayList();
            context.exportImageLayers(imageReference, (name, archive) -> layerFiles.add(this.copyToTemp((String)name, (TarArchive)archive)));
            this.layerFiles = Collections.unmodifiableList(layerFiles);
        }

        private Path copyToTemp(String name, TarArchive archive) throws IOException {
            String[] parts = name.split("/");
            Path path = Files.createTempFile("create-builder-scratch-", parts[0], new FileAttribute[0]);
            try (OutputStream out = Files.newOutputStream(path, new OpenOption[0]);){
                archive.writeTo(out);
            }
            return path;
        }

        void apply(IOConsumer<Layer> layers) throws IOException {
            for (Path path : this.layerFiles) {
                layers.accept(Layer.fromTarArchive(out -> this.copyLayerTar(path, out)));
            }
        }

        private void copyLayerTar(Path path, OutputStream out) throws IOException {
            try (TarArchiveInputStream tarIn = new TarArchiveInputStream(Files.newInputStream(path, new OpenOption[0]));
                 TarArchiveOutputStream tarOut = new TarArchiveOutputStream(out);){
                tarOut.setLongFileMode(3);
                TarArchiveEntry entry = tarIn.getNextTarEntry();
                while (entry != null) {
                    tarOut.putArchiveEntry((ArchiveEntry)entry);
                    StreamUtils.copy((InputStream)tarIn, (OutputStream)tarOut);
                    tarOut.closeArchiveEntry();
                    entry = tarIn.getNextTarEntry();
                }
                tarOut.finish();
            }
            Files.delete(path);
        }
    }
}

