/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.socket;

import java.io.Closeable;
import java.io.IOException;
import java.util.function.IntConsumer;

class FileDescriptor {
    private final Handle openHandle;
    private final Handle closedHandler;
    private final IntConsumer closer;
    private Status status = Status.OPEN;
    private int referenceCount;

    FileDescriptor(int handle, IntConsumer closer) {
        this.openHandle = new Handle(handle);
        this.closedHandler = new Handle(-1);
        this.closer = closer;
    }

    synchronized Handle acquire() {
        ++this.referenceCount;
        return this.status != Status.OPEN ? this.closedHandler : this.openHandle;
    }

    private synchronized void release() {
        --this.referenceCount;
        if (this.referenceCount == 0 && this.status == Status.CLOSE_PENDING) {
            this.closer.accept(this.openHandle.value);
            this.status = Status.CLOSED;
        }
    }

    synchronized void close() {
        if (this.status == Status.OPEN) {
            if (this.referenceCount == 0) {
                this.closer.accept(this.openHandle.value);
                this.status = Status.CLOSED;
            } else {
                this.status = Status.CLOSE_PENDING;
            }
        }
    }

    final class Handle
    implements Closeable {
        private final int value;

        private Handle(int value) {
            this.value = value;
        }

        boolean isClosed() {
            return this.value == -1;
        }

        int intValue() {
            return this.value;
        }

        @Override
        public void close() throws IOException {
            if (!this.isClosed()) {
                FileDescriptor.this.release();
            }
        }
    }

    private static enum Status {
        OPEN,
        CLOSE_PENDING,
        CLOSED;

    }
}

