/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.springframework.boot.context.annotation.ImportCandidates;
import org.springframework.core.io.UrlResource;
import org.springframework.util.Assert;

final class AutoConfigurationReplacements {
    private static final String LOCATION = "META-INF/spring/%s.replacements";
    private final Map<String, String> replacements;

    private AutoConfigurationReplacements(Map<String, String> replacements) {
        this.replacements = Map.copyOf(replacements);
    }

    Set<String> replaceAll(Set<String> classNames) {
        LinkedHashSet<String> replaced = new LinkedHashSet<String>(classNames.size());
        for (String className : classNames) {
            replaced.add(this.replace(className));
        }
        return replaced;
    }

    String replace(String className) {
        return this.replacements.getOrDefault(className, className);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.replacements.equals(((AutoConfigurationReplacements)obj).replacements);
    }

    public int hashCode() {
        return this.replacements.hashCode();
    }

    static AutoConfigurationReplacements load(Class<?> annotation, ClassLoader classLoader) {
        Assert.notNull(annotation, (String)"'annotation' must not be null");
        ClassLoader classLoaderToUse = AutoConfigurationReplacements.decideClassloader(classLoader);
        String location = String.format(LOCATION, annotation.getName());
        Enumeration<URL> urls = AutoConfigurationReplacements.findUrlsInClasspath(classLoaderToUse, location);
        HashMap<String, String> replacements = new HashMap<String, String>();
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            replacements.putAll(AutoConfigurationReplacements.readReplacements(url));
        }
        return new AutoConfigurationReplacements(replacements);
    }

    private static ClassLoader decideClassloader(ClassLoader classLoader) {
        if (classLoader == null) {
            return ImportCandidates.class.getClassLoader();
        }
        return classLoader;
    }

    private static Enumeration<URL> findUrlsInClasspath(ClassLoader classLoader, String location) {
        try {
            return classLoader.getResources(location);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Failed to load configurations from location [" + location + "]", ex);
        }
    }

    private static Map<String, String> readReplacements(URL url) {
        Properties properties;
        BufferedReader reader = new BufferedReader(new InputStreamReader(new UrlResource(url).getInputStream(), StandardCharsets.UTF_8));
        try {
            Properties properties2 = new Properties();
            properties2.load(reader);
            properties = properties2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Unable to load replacements from location [" + url + "]", ex);
            }
        }
        reader.close();
        return properties;
    }
}

