/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.websocket.servlet;

import jakarta.servlet.ServletContext;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.webapp.AbstractConfiguration;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.websocket.core.server.WebSocketMappings;
import org.eclipse.jetty.websocket.core.server.WebSocketServerComponents;
import org.eclipse.jetty.websocket.jakarta.server.internal.JakartaWebSocketServerContainer;
import org.eclipse.jetty.websocket.server.JettyWebSocketServerContainer;
import org.eclipse.jetty.websocket.servlet.WebSocketUpgradeFilter;
import org.springframework.boot.web.embedded.jetty.JettyServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.core.Ordered;

public class JettyWebSocketServletWebServerCustomizer
implements WebServerFactoryCustomizer<JettyServletWebServerFactory>,
Ordered {
    public void customize(JettyServletWebServerFactory factory) {
        factory.addConfigurations(new Configuration[]{new AbstractConfiguration(){

            public void configure(WebAppContext context) throws Exception {
                if (JettyWebSocketServerContainer.getContainer((ServletContext)context.getServletContext()) == null) {
                    WebSocketServerComponents.ensureWebSocketComponents((Server)context.getServer(), (ServletContext)context.getServletContext());
                    JettyWebSocketServerContainer.ensureContainer((ServletContext)context.getServletContext());
                }
                if (JakartaWebSocketServerContainer.getContainer((ServletContext)context.getServletContext()) == null) {
                    WebSocketServerComponents.ensureWebSocketComponents((Server)context.getServer(), (ServletContext)context.getServletContext());
                    WebSocketUpgradeFilter.ensureFilter((ServletContext)context.getServletContext());
                    WebSocketMappings.ensureMappings((ServletContext)context.getServletContext());
                    JakartaWebSocketServerContainer.ensureContainer((ServletContext)context.getServletContext());
                }
            }
        }});
    }

    public int getOrder() {
        return 0;
    }
}

