/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.r2dbc;

import io.r2dbc.pool.ConnectionPool;
import io.r2dbc.pool.ConnectionPoolConfiguration;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryOptions;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.r2dbc.ConnectionFactoryBuilder;
import org.springframework.boot.autoconfigure.r2dbc.ConnectionFactoryOptionsBuilderCustomizer;
import org.springframework.boot.autoconfigure.r2dbc.EmbeddedDatabaseConnection;
import org.springframework.boot.autoconfigure.r2dbc.R2dbcProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.StringUtils;

abstract class ConnectionFactoryConfigurations {
    ConnectionFactoryConfigurations() {
    }

    protected static ConnectionFactory createConnectionFactory(R2dbcProperties properties, ClassLoader classLoader, List<ConnectionFactoryOptionsBuilderCustomizer> optionsCustomizers) {
        return ConnectionFactoryBuilder.of(properties, () -> EmbeddedDatabaseConnection.get(classLoader)).configure(options -> {
            for (ConnectionFactoryOptionsBuilderCustomizer optionsCustomizer : optionsCustomizers) {
                optionsCustomizer.customize((ConnectionFactoryOptions.Builder)options);
            }
        }).build();
    }

    static class PooledConnectionFactoryCondition
    extends SpringBootCondition {
        PooledConnectionFactoryCondition() {
        }

        @Override
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            boolean poolEnabled = (Boolean)context.getEnvironment().getProperty("spring.r2dbc.pool.enabled", Boolean.class, (Object)true);
            if (poolEnabled) {
                boolean pooledUrl;
                String url = context.getEnvironment().getProperty("spring.r2dbc.url");
                boolean bl = pooledUrl = StringUtils.hasText((String)url) && url.contains(":pool:");
                if (pooledUrl) {
                    return ConditionOutcome.noMatch("R2DBC Connection URL contains pooling-related options");
                }
                return ConditionOutcome.match("Pooling is enabled and R2DBC Connection URL does not contain pooling-related options");
            }
            return ConditionOutcome.noMatch("Pooling is disabled");
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(prefix="spring.r2dbc.pool", value={"enabled"}, havingValue="false", matchIfMissing=true)
    @ConditionalOnMissingBean(value={ConnectionFactory.class})
    static class Generic {
        Generic() {
        }

        @Bean
        ConnectionFactory connectionFactory(R2dbcProperties properties, ResourceLoader resourceLoader, ObjectProvider<ConnectionFactoryOptionsBuilderCustomizer> customizers) {
            return ConnectionFactoryConfigurations.createConnectionFactory(properties, resourceLoader.getClassLoader(), customizers.orderedStream().collect(Collectors.toList()));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ConnectionPool.class})
    @Conditional(value={PooledConnectionFactoryCondition.class})
    @ConditionalOnMissingBean(value={ConnectionFactory.class})
    static class Pool {
        Pool() {
        }

        @Bean(destroyMethod="dispose")
        ConnectionPool connectionFactory(R2dbcProperties properties, ResourceLoader resourceLoader, ObjectProvider<ConnectionFactoryOptionsBuilderCustomizer> customizers) {
            ConnectionFactory connectionFactory = ConnectionFactoryConfigurations.createConnectionFactory(properties, resourceLoader.getClassLoader(), customizers.orderedStream().collect(Collectors.toList()));
            R2dbcProperties.Pool pool = properties.getPool();
            PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
            ConnectionPoolConfiguration.Builder builder = ConnectionPoolConfiguration.builder((ConnectionFactory)connectionFactory);
            map.from((Object)pool.getMaxIdleTime()).to(arg_0 -> ((ConnectionPoolConfiguration.Builder)builder).maxIdleTime(arg_0));
            map.from((Object)pool.getMaxLifeTime()).to(arg_0 -> ((ConnectionPoolConfiguration.Builder)builder).maxLifeTime(arg_0));
            map.from((Object)pool.getMaxAcquireTime()).to(arg_0 -> ((ConnectionPoolConfiguration.Builder)builder).maxAcquireTime(arg_0));
            map.from((Object)pool.getMaxCreateConnectionTime()).to(arg_0 -> ((ConnectionPoolConfiguration.Builder)builder).maxCreateConnectionTime(arg_0));
            map.from((Object)pool.getInitialSize()).to(arg_0 -> ((ConnectionPoolConfiguration.Builder)builder).initialSize(arg_0));
            map.from((Object)pool.getMaxSize()).to(arg_0 -> ((ConnectionPoolConfiguration.Builder)builder).maxSize(arg_0));
            map.from((Object)pool.getValidationQuery()).whenHasText().to(arg_0 -> ((ConnectionPoolConfiguration.Builder)builder).validationQuery(arg_0));
            map.from((Object)pool.getValidationDepth()).to(arg_0 -> ((ConnectionPoolConfiguration.Builder)builder).validationDepth(arg_0));
            return new ConnectionPool(builder.build());
        }
    }
}

