/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.reactive.function.client;

import java.util.function.Function;
import org.eclipse.jetty.reactive.client.ReactiveRequest;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.JettyClientHttpConnector;
import org.springframework.http.client.reactive.JettyResourceFactory;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.http.client.reactive.ReactorResourceFactory;
import reactor.netty.http.client.HttpClient;

@Configuration
class ClientHttpConnectorConfiguration {
    ClientHttpConnectorConfiguration() {
    }

    @Configuration
    @ConditionalOnClass(value={ReactiveRequest.class})
    @ConditionalOnMissingBean(value={ClientHttpConnector.class})
    public static class JettyClient {
        @Bean
        @ConditionalOnMissingBean
        public JettyResourceFactory jettyClientResourceFactory() {
            return new JettyResourceFactory();
        }

        @Bean
        public JettyClientHttpConnector jettyClientHttpConnector(JettyResourceFactory jettyResourceFactory) {
            SslContextFactory.Client sslContextFactory = new SslContextFactory.Client();
            org.eclipse.jetty.client.HttpClient httpClient = new org.eclipse.jetty.client.HttpClient((SslContextFactory)sslContextFactory);
            httpClient.setExecutor(jettyResourceFactory.getExecutor());
            httpClient.setByteBufferPool(jettyResourceFactory.getByteBufferPool());
            httpClient.setScheduler(jettyResourceFactory.getScheduler());
            return new JettyClientHttpConnector(httpClient);
        }
    }

    @Configuration
    @ConditionalOnClass(value={HttpClient.class})
    @ConditionalOnMissingBean(value={ClientHttpConnector.class})
    public static class ReactorNetty {
        @Bean
        @ConditionalOnMissingBean
        public ReactorResourceFactory reactorClientResourceFactory() {
            return new ReactorResourceFactory();
        }

        @Bean
        public ReactorClientHttpConnector reactorClientHttpConnector(ReactorResourceFactory reactorResourceFactory) {
            return new ReactorClientHttpConnector(reactorResourceFactory, Function.identity());
        }
    }
}

