/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.kafka;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.kafka.ConcurrentKafkaListenerContainerFactoryConfigurer;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.annotation.EnableKafka;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.listener.AfterRollbackProcessor;
import org.springframework.kafka.listener.ErrorHandler;
import org.springframework.kafka.support.converter.RecordMessageConverter;
import org.springframework.kafka.transaction.KafkaAwareTransactionManager;

@Configuration
@ConditionalOnClass(value={EnableKafka.class})
class KafkaAnnotationDrivenConfiguration {
    private final KafkaProperties properties;
    private final RecordMessageConverter messageConverter;
    private final KafkaTemplate<Object, Object> kafkaTemplate;
    private final KafkaAwareTransactionManager<Object, Object> transactionManager;
    private final ErrorHandler errorHandler;
    private final AfterRollbackProcessor<Object, Object> afterRollbackProcessor;

    KafkaAnnotationDrivenConfiguration(KafkaProperties properties, ObjectProvider<RecordMessageConverter> messageConverter, ObjectProvider<KafkaTemplate<Object, Object>> kafkaTemplate, ObjectProvider<KafkaAwareTransactionManager<Object, Object>> kafkaTransactionManager, ObjectProvider<ErrorHandler> errorHandler, ObjectProvider<AfterRollbackProcessor<Object, Object>> afterRollbackProcessor) {
        this.properties = properties;
        this.messageConverter = (RecordMessageConverter)messageConverter.getIfUnique();
        this.kafkaTemplate = (KafkaTemplate)kafkaTemplate.getIfUnique();
        this.transactionManager = (KafkaAwareTransactionManager)kafkaTransactionManager.getIfUnique();
        this.errorHandler = (ErrorHandler)errorHandler.getIfUnique();
        this.afterRollbackProcessor = (AfterRollbackProcessor)afterRollbackProcessor.getIfUnique();
    }

    @Bean
    @ConditionalOnMissingBean
    public ConcurrentKafkaListenerContainerFactoryConfigurer kafkaListenerContainerFactoryConfigurer() {
        ConcurrentKafkaListenerContainerFactoryConfigurer configurer = new ConcurrentKafkaListenerContainerFactoryConfigurer();
        configurer.setKafkaProperties(this.properties);
        configurer.setMessageConverter(this.messageConverter);
        configurer.setReplyTemplate(this.kafkaTemplate);
        configurer.setTransactionManager(this.transactionManager);
        configurer.setErrorHandler(this.errorHandler);
        configurer.setAfterRollbackProcessor(this.afterRollbackProcessor);
        return configurer;
    }

    @Bean
    @ConditionalOnMissingBean(name={"kafkaListenerContainerFactory"})
    public ConcurrentKafkaListenerContainerFactory<?, ?> kafkaListenerContainerFactory(ConcurrentKafkaListenerContainerFactoryConfigurer configurer, ConsumerFactory<Object, Object> kafkaConsumerFactory) {
        ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
        configurer.configure((ConcurrentKafkaListenerContainerFactory<Object, Object>)factory, kafkaConsumerFactory);
        return factory;
    }

    @Configuration
    @EnableKafka
    @ConditionalOnMissingBean(name={"org.springframework.kafka.config.internalKafkaListenerAnnotationProcessor"})
    protected static class EnableKafkaConfiguration {
        protected EnableKafkaConfiguration() {
        }
    }
}

