/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.flyway;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.callback.Callback;
import org.flywaydb.core.api.callback.FlywayCallback;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.jpa.EntityManagerFactoryDependsOnPostProcessor;
import org.springframework.boot.autoconfigure.flyway.FlywayConfigurationCustomizer;
import org.springframework.boot.autoconfigure.flyway.FlywayDataSource;
import org.springframework.boot.autoconfigure.flyway.FlywayMigrationInitializer;
import org.springframework.boot.autoconfigure.flyway.FlywayMigrationStrategy;
import org.springframework.boot.autoconfigure.flyway.FlywayProperties;
import org.springframework.boot.autoconfigure.flyway.FlywaySchemaManagementProvider;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.autoconfigure.jdbc.JdbcOperationsDependsOnPostProcessor;
import org.springframework.boot.autoconfigure.jdbc.JdbcTemplateAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.NamedParameterJdbcOperationsDependsOnPostProcessor;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.jdbc.DatabaseDriver;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;
import org.springframework.orm.jpa.AbstractEntityManagerFactoryBean;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={Flyway.class})
@ConditionalOnBean(value={DataSource.class})
@ConditionalOnProperty(prefix="spring.flyway", name={"enabled"}, matchIfMissing=true)
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class, JdbcTemplateAutoConfiguration.class, HibernateJpaAutoConfiguration.class})
public class FlywayAutoConfiguration {
    @Bean
    @ConfigurationPropertiesBinding
    public StringOrNumberToMigrationVersionConverter stringOrNumberMigrationVersionConverter() {
        return new StringOrNumberToMigrationVersionConverter();
    }

    @Bean
    public FlywaySchemaManagementProvider flywayDefaultDdlModeProvider(ObjectProvider<Flyway> flyways) {
        return new FlywaySchemaManagementProvider((Iterable<Flyway>)flyways);
    }

    private static class StringOrNumberToMigrationVersionConverter
    implements GenericConverter {
        private static final Set<GenericConverter.ConvertiblePair> CONVERTIBLE_TYPES;

        private StringOrNumberToMigrationVersionConverter() {
        }

        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return CONVERTIBLE_TYPES;
        }

        public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            String value = ObjectUtils.nullSafeToString((Object)source);
            return MigrationVersion.fromVersion((String)value);
        }

        static {
            HashSet<GenericConverter.ConvertiblePair> types = new HashSet<GenericConverter.ConvertiblePair>(2);
            types.add(new GenericConverter.ConvertiblePair(String.class, MigrationVersion.class));
            types.add(new GenericConverter.ConvertiblePair(Number.class, MigrationVersion.class));
            CONVERTIBLE_TYPES = Collections.unmodifiableSet(types);
        }
    }

    private static class LocationResolver {
        private static final String VENDOR_PLACEHOLDER = "{vendor}";
        private final DataSource dataSource;

        LocationResolver(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        public String[] resolveLocations(Collection<String> locations) {
            return this.resolveLocations(StringUtils.toStringArray(locations));
        }

        public String[] resolveLocations(String[] locations) {
            if (this.usesVendorLocation(locations)) {
                DatabaseDriver databaseDriver = this.getDatabaseDriver();
                return this.replaceVendorLocations(locations, databaseDriver);
            }
            return locations;
        }

        private String[] replaceVendorLocations(String[] locations, DatabaseDriver databaseDriver) {
            if (databaseDriver == DatabaseDriver.UNKNOWN) {
                return locations;
            }
            String vendor = databaseDriver.getId();
            return (String[])Arrays.stream(locations).map(location -> location.replace(VENDOR_PLACEHOLDER, vendor)).toArray(String[]::new);
        }

        private DatabaseDriver getDatabaseDriver() {
            try {
                String url = (String)JdbcUtils.extractDatabaseMetaData((DataSource)this.dataSource, (String)"getURL");
                return DatabaseDriver.fromJdbcUrl((String)url);
            }
            catch (MetaDataAccessException ex) {
                throw new IllegalStateException(ex);
            }
        }

        private boolean usesVendorLocation(String ... locations) {
            for (String location : locations) {
                if (!location.contains(VENDOR_PLACEHOLDER)) continue;
                return true;
            }
            return false;
        }
    }

    @Configuration
    @ConditionalOnClass(value={NamedParameterJdbcOperations.class})
    @ConditionalOnBean(value={NamedParameterJdbcOperations.class})
    protected static class FlywayNamedParameterJdbcOperationsDependencyConfiguration
    extends NamedParameterJdbcOperationsDependsOnPostProcessor {
        public FlywayNamedParameterJdbcOperationsDependencyConfiguration() {
            super("flyway");
        }
    }

    @Configuration
    @ConditionalOnClass(value={JdbcOperations.class})
    @ConditionalOnBean(value={JdbcOperations.class})
    protected static class FlywayJdbcOperationsDependencyConfiguration
    extends JdbcOperationsDependsOnPostProcessor {
        public FlywayJdbcOperationsDependencyConfiguration() {
            super("flyway");
        }
    }

    @Configuration
    @ConditionalOnClass(value={LocalContainerEntityManagerFactoryBean.class})
    @ConditionalOnBean(value={AbstractEntityManagerFactoryBean.class})
    protected static class FlywayJpaDependencyConfiguration
    extends EntityManagerFactoryDependsOnPostProcessor {
        public FlywayJpaDependencyConfiguration() {
            super("flyway");
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={Flyway.class})
    @EnableConfigurationProperties(value={DataSourceProperties.class, FlywayProperties.class})
    public static class FlywayConfiguration {
        private final FlywayProperties properties;
        private final DataSourceProperties dataSourceProperties;
        private final ResourceLoader resourceLoader;
        private final DataSource dataSource;
        private final DataSource flywayDataSource;
        private final FlywayMigrationStrategy migrationStrategy;
        private final List<FlywayConfigurationCustomizer> configurationCustomizers;
        private final List<Callback> callbacks;
        private final List<FlywayCallback> flywayCallbacks;

        public FlywayConfiguration(FlywayProperties properties, DataSourceProperties dataSourceProperties, ResourceLoader resourceLoader, ObjectProvider<DataSource> dataSource, @FlywayDataSource ObjectProvider<DataSource> flywayDataSource, ObjectProvider<FlywayMigrationStrategy> migrationStrategy, ObjectProvider<FlywayConfigurationCustomizer> fluentConfigurationCustomizers, ObjectProvider<Callback> callbacks, ObjectProvider<FlywayCallback> flywayCallbacks) {
            this.properties = properties;
            this.dataSourceProperties = dataSourceProperties;
            this.resourceLoader = resourceLoader;
            this.dataSource = (DataSource)dataSource.getIfUnique();
            this.flywayDataSource = (DataSource)flywayDataSource.getIfAvailable();
            this.migrationStrategy = (FlywayMigrationStrategy)migrationStrategy.getIfAvailable();
            this.configurationCustomizers = fluentConfigurationCustomizers.orderedStream().collect(Collectors.toList());
            this.callbacks = callbacks.orderedStream().collect(Collectors.toList());
            this.flywayCallbacks = flywayCallbacks.orderedStream().collect(Collectors.toList());
        }

        @Bean
        public Flyway flyway() {
            FluentConfiguration configuration = new FluentConfiguration();
            DataSource dataSource = this.configureDataSource(configuration);
            this.checkLocationExists(dataSource);
            this.configureProperties(configuration);
            this.configureCallbacks(configuration);
            this.configurationCustomizers.forEach(customizer -> customizer.customize(configuration));
            Flyway flyway = configuration.load();
            this.configureFlywayCallbacks(flyway);
            return flyway;
        }

        private DataSource configureDataSource(FluentConfiguration configuration) {
            if (this.properties.isCreateDataSource()) {
                String url = this.getProperty(this.properties::getUrl, this.dataSourceProperties::determineUrl);
                String user = this.getProperty(this.properties::getUser, this.dataSourceProperties::determineUsername);
                String password = this.getProperty(this.properties::getPassword, this.dataSourceProperties::determinePassword);
                configuration.dataSource(url, user, password);
                if (!CollectionUtils.isEmpty(this.properties.getInitSqls())) {
                    String initSql = StringUtils.collectionToDelimitedString(this.properties.getInitSqls(), (String)"\n");
                    configuration.initSql(initSql);
                }
            } else if (this.flywayDataSource != null) {
                configuration.dataSource(this.flywayDataSource);
            } else {
                configuration.dataSource(this.dataSource);
            }
            return configuration.getDataSource();
        }

        private void checkLocationExists(DataSource dataSource) {
            if (this.properties.isCheckLocation()) {
                String[] locations = new LocationResolver(dataSource).resolveLocations(this.properties.getLocations());
                Assert.state((locations.length != 0 ? 1 : 0) != 0, (String)"Migration script locations not configured");
                boolean exists = this.hasAtLeastOneLocation(locations);
                Assert.state((boolean)exists, () -> "Cannot find migrations location in: " + Arrays.asList(locations) + " (please add migrations or check your Flyway configuration)");
            }
        }

        private void configureProperties(FluentConfiguration configuration) {
            PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
            String[] locations = new LocationResolver(configuration.getDataSource()).resolveLocations(this.properties.getLocations());
            map.from((Object)locations).to(arg_0 -> ((FluentConfiguration)configuration).locations(arg_0));
            map.from((Object)this.properties.getEncoding()).to(arg_0 -> ((FluentConfiguration)configuration).encoding(arg_0));
            map.from((Object)this.properties.getConnectRetries()).to(arg_0 -> ((FluentConfiguration)configuration).connectRetries(arg_0));
            map.from(this.properties.getSchemas()).as(StringUtils::toStringArray).to(arg_0 -> ((FluentConfiguration)configuration).schemas(arg_0));
            map.from((Object)this.properties.getTable()).to(arg_0 -> ((FluentConfiguration)configuration).table(arg_0));
            map.from((Object)this.properties.getBaselineDescription()).to(arg_0 -> ((FluentConfiguration)configuration).baselineDescription(arg_0));
            map.from((Object)this.properties.getBaselineVersion()).to(arg_0 -> ((FluentConfiguration)configuration).baselineVersion(arg_0));
            map.from((Object)this.properties.getInstalledBy()).to(arg_0 -> ((FluentConfiguration)configuration).installedBy(arg_0));
            map.from(this.properties.getPlaceholders()).to(arg_0 -> ((FluentConfiguration)configuration).placeholders(arg_0));
            map.from((Object)this.properties.getPlaceholderPrefix()).to(arg_0 -> ((FluentConfiguration)configuration).placeholderPrefix(arg_0));
            map.from((Object)this.properties.getPlaceholderSuffix()).to(arg_0 -> ((FluentConfiguration)configuration).placeholderSuffix(arg_0));
            map.from((Object)this.properties.isPlaceholderReplacement()).to(arg_0 -> ((FluentConfiguration)configuration).placeholderReplacement(arg_0));
            map.from((Object)this.properties.getSqlMigrationPrefix()).to(arg_0 -> ((FluentConfiguration)configuration).sqlMigrationPrefix(arg_0));
            map.from(this.properties.getSqlMigrationSuffixes()).as(StringUtils::toStringArray).to(arg_0 -> ((FluentConfiguration)configuration).sqlMigrationSuffixes(arg_0));
            map.from((Object)this.properties.getSqlMigrationSeparator()).to(arg_0 -> ((FluentConfiguration)configuration).sqlMigrationSeparator(arg_0));
            map.from((Object)this.properties.getRepeatableSqlMigrationPrefix()).to(arg_0 -> ((FluentConfiguration)configuration).repeatableSqlMigrationPrefix(arg_0));
            map.from((Object)this.properties.getTarget()).to(arg_0 -> ((FluentConfiguration)configuration).target(arg_0));
            map.from((Object)this.properties.isBaselineOnMigrate()).to(arg_0 -> ((FluentConfiguration)configuration).baselineOnMigrate(arg_0));
            map.from((Object)this.properties.isCleanDisabled()).to(arg_0 -> ((FluentConfiguration)configuration).cleanDisabled(arg_0));
            map.from((Object)this.properties.isCleanOnValidationError()).to(arg_0 -> ((FluentConfiguration)configuration).cleanOnValidationError(arg_0));
            map.from((Object)this.properties.isGroup()).to(arg_0 -> ((FluentConfiguration)configuration).group(arg_0));
            map.from((Object)this.properties.isIgnoreMissingMigrations()).to(arg_0 -> ((FluentConfiguration)configuration).ignoreMissingMigrations(arg_0));
            map.from((Object)this.properties.isIgnoreIgnoredMigrations()).to(arg_0 -> ((FluentConfiguration)configuration).ignoreIgnoredMigrations(arg_0));
            map.from((Object)this.properties.isIgnorePendingMigrations()).to(arg_0 -> ((FluentConfiguration)configuration).ignorePendingMigrations(arg_0));
            map.from((Object)this.properties.isIgnoreFutureMigrations()).to(arg_0 -> ((FluentConfiguration)configuration).ignoreFutureMigrations(arg_0));
            map.from((Object)this.properties.isMixed()).to(arg_0 -> ((FluentConfiguration)configuration).mixed(arg_0));
            map.from((Object)this.properties.isOutOfOrder()).to(arg_0 -> ((FluentConfiguration)configuration).outOfOrder(arg_0));
            map.from((Object)this.properties.isSkipDefaultCallbacks()).to(arg_0 -> ((FluentConfiguration)configuration).skipDefaultCallbacks(arg_0));
            map.from((Object)this.properties.isSkipDefaultResolvers()).to(arg_0 -> ((FluentConfiguration)configuration).skipDefaultResolvers(arg_0));
            map.from((Object)this.properties.isValidateOnMigrate()).to(arg_0 -> ((FluentConfiguration)configuration).validateOnMigrate(arg_0));
        }

        private void configureCallbacks(FluentConfiguration configuration) {
            if (!this.callbacks.isEmpty()) {
                configuration.callbacks(this.callbacks.toArray(new Callback[0]));
            }
        }

        private void configureFlywayCallbacks(Flyway flyway) {
            if (!this.flywayCallbacks.isEmpty()) {
                if (!this.callbacks.isEmpty()) {
                    throw new IllegalStateException("Found a mixture of Callback and FlywayCallback beans. One type must be used exclusively.");
                }
                flyway.setCallbacks(this.flywayCallbacks.toArray(new FlywayCallback[0]));
            }
        }

        private String getProperty(Supplier<String> property, Supplier<String> defaultValue) {
            String value = property.get();
            return value != null ? value : defaultValue.get();
        }

        private boolean hasAtLeastOneLocation(String ... locations) {
            for (String location : locations) {
                if (!this.resourceLoader.getResource(this.normalizePrefix(location)).exists()) continue;
                return true;
            }
            return false;
        }

        private String normalizePrefix(String location) {
            return location.replace("filesystem:", "file:");
        }

        @Bean
        @ConditionalOnMissingBean
        public FlywayMigrationInitializer flywayInitializer(Flyway flyway) {
            return new FlywayMigrationInitializer(flyway, this.migrationStrategy);
        }

        @Configuration
        @ConditionalOnClass(value={NamedParameterJdbcOperations.class})
        @ConditionalOnBean(value={NamedParameterJdbcOperations.class})
        protected static class FlywayInitializerNamedParameterJdbcOperationsDependencyConfiguration
        extends NamedParameterJdbcOperationsDependsOnPostProcessor {
            public FlywayInitializerNamedParameterJdbcOperationsDependencyConfiguration() {
                super("flywayInitializer");
            }
        }

        @Configuration
        @ConditionalOnClass(value={JdbcOperations.class})
        @ConditionalOnBean(value={JdbcOperations.class})
        protected static class FlywayInitializerJdbcOperationsDependencyConfiguration
        extends JdbcOperationsDependsOnPostProcessor {
            public FlywayInitializerJdbcOperationsDependencyConfiguration() {
                super("flywayInitializer");
            }
        }

        @Configuration
        @ConditionalOnClass(value={LocalContainerEntityManagerFactoryBean.class})
        @ConditionalOnBean(value={AbstractEntityManagerFactoryBean.class})
        protected static class FlywayInitializerJpaDependencyConfiguration
        extends EntityManagerFactoryDependsOnPostProcessor {
            public FlywayInitializerJpaDependencyConfiguration() {
                super("flywayInitializer");
            }
        }
    }
}

