/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.couchbase;

import com.couchbase.client.core.env.KeyValueServiceConfig;
import com.couchbase.client.core.env.QueryServiceConfig;
import com.couchbase.client.core.env.ViewServiceConfig;
import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.CouchbaseCluster;
import com.couchbase.client.java.cluster.ClusterInfo;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.env.DefaultCouchbaseEnvironment;
import java.util.List;
import org.springframework.boot.autoconfigure.couchbase.CouchbaseProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Primary;

@Configuration
public class CouchbaseConfiguration {
    private final CouchbaseProperties properties;

    public CouchbaseConfiguration(CouchbaseProperties properties) {
        this.properties = properties;
    }

    @Bean
    @Primary
    public DefaultCouchbaseEnvironment couchbaseEnvironment() {
        return this.initializeEnvironmentBuilder(this.properties).build();
    }

    @Bean
    @Primary
    public Cluster couchbaseCluster() {
        return CouchbaseCluster.create((CouchbaseEnvironment)this.couchbaseEnvironment(), this.determineBootstrapHosts());
    }

    protected List<String> determineBootstrapHosts() {
        return this.properties.getBootstrapHosts();
    }

    @Bean
    @Primary
    @DependsOn(value={"couchbaseClient"})
    public ClusterInfo couchbaseClusterInfo() {
        return this.couchbaseCluster().clusterManager(this.properties.getBucket().getName(), this.properties.getBucket().getPassword()).info();
    }

    @Bean
    @Primary
    public Bucket couchbaseClient() {
        return this.couchbaseCluster().openBucket(this.properties.getBucket().getName(), this.properties.getBucket().getPassword());
    }

    protected DefaultCouchbaseEnvironment.Builder initializeEnvironmentBuilder(CouchbaseProperties properties) {
        CouchbaseProperties.Ssl ssl;
        CouchbaseProperties.Endpoints endpoints = properties.getEnv().getEndpoints();
        CouchbaseProperties.Timeouts timeouts = properties.getEnv().getTimeouts();
        DefaultCouchbaseEnvironment.Builder builder = DefaultCouchbaseEnvironment.builder();
        if (timeouts.getConnect() != null) {
            builder = builder.connectTimeout(timeouts.getConnect().toMillis());
        }
        builder = (DefaultCouchbaseEnvironment.Builder)builder.keyValueServiceConfig(KeyValueServiceConfig.create((int)endpoints.getKeyValue()));
        if (timeouts.getKeyValue() != null) {
            builder = builder.kvTimeout(timeouts.getKeyValue().toMillis());
        }
        if (timeouts.getQuery() != null) {
            builder = builder.queryTimeout(timeouts.getQuery().toMillis());
            builder = (DefaultCouchbaseEnvironment.Builder)builder.queryServiceConfig(this.getQueryServiceConfig(endpoints));
            builder = (DefaultCouchbaseEnvironment.Builder)builder.viewServiceConfig(this.getViewServiceConfig(endpoints));
        }
        if (timeouts.getSocketConnect() != null) {
            builder = (DefaultCouchbaseEnvironment.Builder)builder.socketConnectTimeout((int)timeouts.getSocketConnect().toMillis());
        }
        if (timeouts.getView() != null) {
            builder = builder.viewTimeout(timeouts.getView().toMillis());
        }
        if ((ssl = properties.getEnv().getSsl()).getEnabled().booleanValue()) {
            builder = (DefaultCouchbaseEnvironment.Builder)builder.sslEnabled(true);
            if (ssl.getKeyStore() != null) {
                builder = (DefaultCouchbaseEnvironment.Builder)builder.sslKeystoreFile(ssl.getKeyStore());
            }
            if (ssl.getKeyStorePassword() != null) {
                builder = (DefaultCouchbaseEnvironment.Builder)builder.sslKeystorePassword(ssl.getKeyStorePassword());
            }
        }
        return builder;
    }

    private QueryServiceConfig getQueryServiceConfig(CouchbaseProperties.Endpoints endpoints) {
        return QueryServiceConfig.create((int)endpoints.getQueryservice().getMinEndpoints(), (int)endpoints.getQueryservice().getMaxEndpoints());
    }

    private ViewServiceConfig getViewServiceConfig(CouchbaseProperties.Endpoints endpoints) {
        return ViewServiceConfig.create((int)endpoints.getViewservice().getMinEndpoints(), (int)endpoints.getViewservice().getMaxEndpoints());
    }
}

