/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.data.neo4j;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.session.event.EventListener;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.data.neo4j.Neo4jBookmarkManagementConfiguration;
import org.springframework.boot.autoconfigure.data.neo4j.Neo4jProperties;
import org.springframework.boot.autoconfigure.domain.EntityScanPackages;
import org.springframework.boot.autoconfigure.transaction.TransactionManagerCustomizers;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.neo4j.transaction.Neo4jTransactionManager;
import org.springframework.data.neo4j.web.support.OpenSessionInViewInterceptor;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.WebRequestInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ConditionalOnClass(value={SessionFactory.class, Neo4jTransactionManager.class, PlatformTransactionManager.class})
@ConditionalOnMissingBean(value={SessionFactory.class})
@EnableConfigurationProperties(value={Neo4jProperties.class})
@Import(value={Neo4jBookmarkManagementConfiguration.class})
public class Neo4jDataAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public org.neo4j.ogm.config.Configuration configuration(Neo4jProperties properties) {
        return properties.createConfiguration();
    }

    @Bean
    public SessionFactory sessionFactory(org.neo4j.ogm.config.Configuration configuration, ApplicationContext applicationContext, ObjectProvider<EventListener> eventListeners) {
        SessionFactory sessionFactory = new SessionFactory(configuration, this.getPackagesToScan(applicationContext));
        eventListeners.stream().forEach(arg_0 -> ((SessionFactory)sessionFactory).register(arg_0));
        return sessionFactory;
    }

    @Bean
    @ConditionalOnMissingBean(value={PlatformTransactionManager.class})
    public Neo4jTransactionManager transactionManager(SessionFactory sessionFactory, Neo4jProperties properties, ObjectProvider<TransactionManagerCustomizers> transactionManagerCustomizers) {
        return this.customize(new Neo4jTransactionManager(sessionFactory), (TransactionManagerCustomizers)transactionManagerCustomizers.getIfAvailable());
    }

    private Neo4jTransactionManager customize(Neo4jTransactionManager transactionManager, TransactionManagerCustomizers customizers) {
        if (customizers != null) {
            customizers.customize((PlatformTransactionManager)transactionManager);
        }
        return transactionManager;
    }

    private String[] getPackagesToScan(ApplicationContext applicationContext) {
        List<String> packages = EntityScanPackages.get((BeanFactory)applicationContext).getPackageNames();
        if (packages.isEmpty() && AutoConfigurationPackages.has((BeanFactory)applicationContext)) {
            packages = AutoConfigurationPackages.get((BeanFactory)applicationContext);
        }
        return StringUtils.toStringArray(packages);
    }

    @Configuration
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @ConditionalOnClass(value={WebMvcConfigurer.class, OpenSessionInViewInterceptor.class})
    @ConditionalOnMissingBean(value={OpenSessionInViewInterceptor.class})
    @ConditionalOnProperty(prefix="spring.data.neo4j", name={"open-in-view"}, havingValue="true", matchIfMissing=true)
    protected static class Neo4jWebConfiguration {
        protected Neo4jWebConfiguration() {
        }

        @Configuration
        protected static class Neo4jWebMvcConfiguration
        implements WebMvcConfigurer {
            private static final Log logger = LogFactory.getLog(Neo4jWebMvcConfiguration.class);
            private final Neo4jProperties neo4jProperties;

            protected Neo4jWebMvcConfiguration(Neo4jProperties neo4jProperties) {
                this.neo4jProperties = neo4jProperties;
            }

            @Bean
            public OpenSessionInViewInterceptor neo4jOpenSessionInViewInterceptor() {
                if (this.neo4jProperties.getOpenInView() == null) {
                    logger.warn((Object)"spring.data.neo4j.open-in-view is enabled by default.Therefore, database queries may be performed during view rendering. Explicitly configure spring.data.neo4j.open-in-view to disable this warning");
                }
                return new OpenSessionInViewInterceptor();
            }

            public void addInterceptors(InterceptorRegistry registry) {
                registry.addWebRequestInterceptor((WebRequestInterceptor)this.neo4jOpenSessionInViewInterceptor());
            }
        }
    }
}

