/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.boot.autoconfigure.http.HttpMessageConvertersAutoConfiguration;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;

@Configuration
@AutoConfigureAfter(value={HttpMessageConvertersAutoConfiguration.class})
@ConditionalOnClass(value={RestTemplate.class})
public class RestTemplateAutoConfiguration {
    private final ObjectProvider<HttpMessageConverters> messageConverters;
    private final ObjectProvider<List<RestTemplateCustomizer>> restTemplateCustomizers;

    public RestTemplateAutoConfiguration(ObjectProvider<HttpMessageConverters> messageConverters, ObjectProvider<List<RestTemplateCustomizer>> restTemplateCustomizers) {
        this.messageConverters = messageConverters;
        this.restTemplateCustomizers = restTemplateCustomizers;
    }

    @Bean
    @ConditionalOnMissingBean
    public RestTemplateBuilder restTemplateBuilder() {
        ArrayList customizers;
        RestTemplateBuilder builder = new RestTemplateBuilder(new RestTemplateCustomizer[0]);
        HttpMessageConverters converters = (HttpMessageConverters)this.messageConverters.getIfUnique();
        if (converters != null) {
            builder = builder.messageConverters(converters.getConverters());
        }
        if (!CollectionUtils.isEmpty((Collection)(customizers = (ArrayList)this.restTemplateCustomizers.getIfAvailable()))) {
            customizers = new ArrayList(customizers);
            AnnotationAwareOrderComparator.sort(customizers);
            builder = builder.customizers(customizers);
        }
        return builder;
    }
}

