/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.cassandra;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.data.cassandra.core.CassandraOperations;
import org.springframework.util.Assert;

public class CassandraHealthIndicator
extends AbstractHealthIndicator {
    private static final Statement SELECT = new SimpleStatement("SELECT release_version FROM system.local").setConsistencyLevel(ConsistencyLevel.LOCAL_ONE);
    private CassandraOperations cassandraOperations;

    public CassandraHealthIndicator() {
        super("Cassandra health check failed");
    }

    public CassandraHealthIndicator(CassandraOperations cassandraOperations) {
        super("Cassandra health check failed");
        Assert.notNull((Object)cassandraOperations, (String)"CassandraOperations must not be null");
        this.cassandraOperations = cassandraOperations;
    }

    @Override
    protected void doHealthCheck(Health.Builder builder) throws Exception {
        String version = (String)this.cassandraOperations.getCqlOperations().queryForObject(SELECT, String.class);
        builder.up().withDetail("version", version);
    }
}

