/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.jdbc;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.SimpleAutowireCandidateResolver;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.autoconfigure.jdbc.DataSourceHealthIndicatorProperties;
import org.springframework.boot.actuate.health.CompositeHealthContributor;
import org.springframework.boot.actuate.health.HealthContributor;
import org.springframework.boot.actuate.health.NamedContributor;
import org.springframework.boot.actuate.jdbc.DataSourceHealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.jdbc.metadata.CompositeDataSourcePoolMetadataProvider;
import org.springframework.boot.jdbc.metadata.DataSourcePoolMetadata;
import org.springframework.boot.jdbc.metadata.DataSourcePoolMetadataProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;
import org.springframework.util.Assert;

@AutoConfiguration(after={DataSourceAutoConfiguration.class})
@ConditionalOnClass(value={JdbcTemplate.class, AbstractRoutingDataSource.class})
@ConditionalOnBean(value={DataSource.class})
@ConditionalOnEnabledHealthIndicator(value="db")
@EnableConfigurationProperties(value={DataSourceHealthIndicatorProperties.class})
public class DataSourceHealthContributorAutoConfiguration
implements InitializingBean {
    private final Collection<DataSourcePoolMetadataProvider> metadataProviders;
    private DataSourcePoolMetadataProvider poolMetadataProvider;

    public DataSourceHealthContributorAutoConfiguration(ObjectProvider<DataSourcePoolMetadataProvider> metadataProviders) {
        this.metadataProviders = metadataProviders.orderedStream().toList();
    }

    public void afterPropertiesSet() {
        this.poolMetadataProvider = new CompositeDataSourcePoolMetadataProvider(this.metadataProviders);
    }

    @Bean
    @ConditionalOnMissingBean(name={"dbHealthIndicator", "dbHealthContributor"})
    public HealthContributor dbHealthContributor(ConfigurableListableBeanFactory beanFactory, DataSourceHealthIndicatorProperties dataSourceHealthIndicatorProperties) {
        Map dataSources = SimpleAutowireCandidateResolver.resolveAutowireCandidates((ConfigurableListableBeanFactory)beanFactory, DataSource.class, (boolean)false, (boolean)true);
        if (dataSourceHealthIndicatorProperties.isIgnoreRoutingDataSources()) {
            Map<String, DataSource> filteredDatasources = dataSources.entrySet().stream().filter(e -> !DataSourceHealthContributorAutoConfiguration.isRoutingDataSource((DataSource)e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            return this.createContributor(filteredDatasources);
        }
        return this.createContributor(dataSources);
    }

    private HealthContributor createContributor(Map<String, DataSource> beans) {
        Assert.notEmpty(beans, (String)"'beans' must not be empty");
        if (beans.size() == 1) {
            return this.createContributor(beans.values().iterator().next());
        }
        return CompositeHealthContributor.fromMap(beans, this::createContributor);
    }

    private HealthContributor createContributor(DataSource source) {
        if (DataSourceHealthContributorAutoConfiguration.isRoutingDataSource(source)) {
            return new RoutingDataSourceHealthContributor(DataSourceHealthContributorAutoConfiguration.extractRoutingDataSource(source), this::createContributor);
        }
        return new DataSourceHealthIndicator(source, this.getValidationQuery(source));
    }

    private String getValidationQuery(DataSource source) {
        DataSourcePoolMetadata poolMetadata = this.poolMetadataProvider.getDataSourcePoolMetadata(source);
        return poolMetadata != null ? poolMetadata.getValidationQuery() : null;
    }

    private static boolean isRoutingDataSource(DataSource dataSource) {
        if (dataSource instanceof AbstractRoutingDataSource) {
            return true;
        }
        try {
            return dataSource.isWrapperFor(AbstractRoutingDataSource.class);
        }
        catch (SQLException ex) {
            return false;
        }
    }

    private static AbstractRoutingDataSource extractRoutingDataSource(DataSource dataSource) {
        if (dataSource instanceof AbstractRoutingDataSource) {
            AbstractRoutingDataSource routingDataSource = (AbstractRoutingDataSource)dataSource;
            return routingDataSource;
        }
        try {
            return dataSource.unwrap(AbstractRoutingDataSource.class);
        }
        catch (SQLException ex) {
            throw new IllegalStateException("Failed to unwrap AbstractRoutingDataSource from " + String.valueOf(dataSource), ex);
        }
    }

    static class RoutingDataSourceHealthContributor
    implements CompositeHealthContributor {
        private final CompositeHealthContributor delegate;
        private static final String UNNAMED_DATASOURCE_KEY = "unnamed";

        RoutingDataSourceHealthContributor(AbstractRoutingDataSource routingDataSource, Function<DataSource, HealthContributor> contributorFunction) {
            Map<String, DataSource> routedDataSources = routingDataSource.getResolvedDataSources().entrySet().stream().collect(Collectors.toMap(e -> Objects.toString(e.getKey(), UNNAMED_DATASOURCE_KEY), Map.Entry::getValue));
            this.delegate = CompositeHealthContributor.fromMap(routedDataSources, contributorFunction);
        }

        public HealthContributor getContributor(String name) {
            return (HealthContributor)this.delegate.getContributor(name);
        }

        public Iterator<NamedContributor<HealthContributor>> iterator() {
            return this.delegate.iterator();
        }
    }
}

