/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.tracing;

import brave.CurrentSpanCustomizer;
import brave.SpanCustomizer;
import brave.Tracer;
import brave.Tracing;
import brave.TracingCustomizer;
import brave.handler.SpanHandler;
import brave.propagation.CurrentTraceContext;
import brave.propagation.CurrentTraceContextCustomizer;
import brave.propagation.Propagation;
import brave.propagation.ThreadLocalCurrentTraceContext;
import brave.sampler.Sampler;
import io.micrometer.tracing.BaggageManager;
import io.micrometer.tracing.CurrentTraceContext;
import io.micrometer.tracing.brave.bridge.BraveBaggageManager;
import io.micrometer.tracing.brave.bridge.BraveCurrentTraceContext;
import io.micrometer.tracing.brave.bridge.BravePropagator;
import io.micrometer.tracing.brave.bridge.BraveSpanCustomizer;
import io.micrometer.tracing.brave.bridge.BraveTracer;
import io.micrometer.tracing.brave.bridge.CompositeSpanHandler;
import io.micrometer.tracing.exporter.SpanExportingPredicate;
import io.micrometer.tracing.exporter.SpanFilter;
import io.micrometer.tracing.exporter.SpanReporter;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.tracing.BravePropagationConfigurations;
import org.springframework.boot.actuate.autoconfigure.tracing.MicrometerTracingAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.tracing.NoopTracerAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.tracing.TracingProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.IncompatibleConfigurationException;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;

@AutoConfiguration(before={MicrometerTracingAutoConfiguration.class, NoopTracerAutoConfiguration.class})
@ConditionalOnClass(value={Tracer.class, BraveTracer.class})
@EnableConfigurationProperties(value={TracingProperties.class})
@Import(value={BravePropagationConfigurations.PropagationWithoutBaggage.class, BravePropagationConfigurations.PropagationWithBaggage.class, BravePropagationConfigurations.NoPropagation.class})
public class BraveAutoConfiguration {
    static final BraveBaggageManager BRAVE_BAGGAGE_MANAGER = new BraveBaggageManager();
    private static final String DEFAULT_APPLICATION_NAME = "application";

    @Bean
    @ConditionalOnMissingBean
    @Order(value=-2147483648)
    CompositeSpanHandler compositeSpanHandler(ObjectProvider<SpanExportingPredicate> predicates, ObjectProvider<SpanReporter> reporters, ObjectProvider<SpanFilter> filters) {
        return new CompositeSpanHandler(predicates.orderedStream().toList(), reporters.orderedStream().toList(), filters.orderedStream().toList());
    }

    @Bean
    @ConditionalOnMissingBean
    public Tracing braveTracing(Environment environment, TracingProperties properties, List<SpanHandler> spanHandlers, List<TracingCustomizer> tracingCustomizers, brave.propagation.CurrentTraceContext currentTraceContext, Propagation.Factory propagationFactory, Sampler sampler) {
        if (properties.getBrave().isSpanJoiningSupported()) {
            if (properties.getPropagation().getType() != null && properties.getPropagation().getType().contains((Object)TracingProperties.Propagation.PropagationType.W3C)) {
                throw new IncompatibleConfigurationException(new String[]{"management.tracing.propagation.type", "management.tracing.brave.span-joining-supported"});
            }
            if (properties.getPropagation().getType() == null && properties.getPropagation().getProduce().contains((Object)TracingProperties.Propagation.PropagationType.W3C)) {
                throw new IncompatibleConfigurationException(new String[]{"management.tracing.propagation.produce", "management.tracing.brave.span-joining-supported"});
            }
            if (properties.getPropagation().getType() == null && properties.getPropagation().getConsume().contains((Object)TracingProperties.Propagation.PropagationType.W3C)) {
                throw new IncompatibleConfigurationException(new String[]{"management.tracing.propagation.consume", "management.tracing.brave.span-joining-supported"});
            }
        }
        String applicationName = environment.getProperty("spring.application.name", DEFAULT_APPLICATION_NAME);
        Tracing.Builder builder = Tracing.newBuilder().currentTraceContext(currentTraceContext).traceId128Bit(true).supportsJoin(properties.getBrave().isSpanJoiningSupported()).propagationFactory(propagationFactory).sampler(sampler).localServiceName(applicationName);
        spanHandlers.forEach(arg_0 -> ((Tracing.Builder)builder).addSpanHandler(arg_0));
        for (TracingCustomizer tracingCustomizer : tracingCustomizers) {
            tracingCustomizer.customize(builder);
        }
        return builder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    public Tracer braveTracer(Tracing tracing) {
        return tracing.tracer();
    }

    @Bean
    @ConditionalOnMissingBean
    public brave.propagation.CurrentTraceContext braveCurrentTraceContext(List<CurrentTraceContext.ScopeDecorator> scopeDecorators, List<CurrentTraceContextCustomizer> currentTraceContextCustomizers) {
        ThreadLocalCurrentTraceContext.Builder builder = ThreadLocalCurrentTraceContext.newBuilder();
        scopeDecorators.forEach(arg_0 -> ((ThreadLocalCurrentTraceContext.Builder)builder).addScopeDecorator(arg_0));
        for (CurrentTraceContextCustomizer currentTraceContextCustomizer : currentTraceContextCustomizers) {
            currentTraceContextCustomizer.customize((CurrentTraceContext.Builder)builder);
        }
        return builder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    public Sampler braveSampler(TracingProperties properties) {
        return Sampler.create((float)properties.getSampling().getProbability());
    }

    @Bean
    @ConditionalOnMissingBean(value={io.micrometer.tracing.Tracer.class})
    BraveTracer braveTracerBridge(Tracer tracer, brave.propagation.CurrentTraceContext currentTraceContext) {
        return new BraveTracer(tracer, (CurrentTraceContext)new BraveCurrentTraceContext(currentTraceContext), (BaggageManager)BRAVE_BAGGAGE_MANAGER);
    }

    @Bean
    @ConditionalOnMissingBean
    BravePropagator bravePropagator(Tracing tracing) {
        return new BravePropagator(tracing);
    }

    @Bean
    @ConditionalOnMissingBean(value={SpanCustomizer.class})
    CurrentSpanCustomizer currentSpanCustomizer(Tracing tracing) {
        return CurrentSpanCustomizer.create((Tracing)tracing);
    }

    @Bean
    @ConditionalOnMissingBean(value={io.micrometer.tracing.SpanCustomizer.class})
    BraveSpanCustomizer braveSpanCustomizer(SpanCustomizer spanCustomizer) {
        return new BraveSpanCustomizer(spanCustomizer);
    }
}

