/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.influx;

import java.util.Map;
import org.influxdb.InfluxDB;
import org.springframework.boot.actuate.autoconfigure.health.CompositeHealthContributorConfiguration;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.health.HealthContributor;
import org.springframework.boot.actuate.influx.InfluxDbHealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.influx.InfluxDbAutoConfiguration;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={InfluxDbAutoConfiguration.class})
@ConditionalOnClass(value={InfluxDB.class})
@ConditionalOnBean(value={InfluxDB.class})
@ConditionalOnEnabledHealthIndicator(value="influxdb")
@Deprecated(since="3.2.0", forRemoval=true)
public class InfluxDbHealthContributorAutoConfiguration
extends CompositeHealthContributorConfiguration<InfluxDbHealthIndicator, InfluxDB> {
    public InfluxDbHealthContributorAutoConfiguration() {
        super(InfluxDbHealthIndicator::new);
    }

    @Bean
    @ConditionalOnMissingBean(name={"influxDbHealthIndicator", "influxDbHealthContributor"})
    public HealthContributor influxDbHealthContributor(Map<String, InfluxDB> influxDbs) {
        return (HealthContributor)this.createContributor(influxDbs);
    }
}

